/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.area;

import com.sk89q.craftbook.mech.area.CuboidCopy;
import com.sk89q.craftbook.mech.area.CuboidCopyException;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.io.IOException;
import org.bukkit.World;

public class MCEditCuboidCopy
extends CuboidCopy {
    private CuboidClipboard clipboard;

    public MCEditCuboidCopy(Vector origin, Vector size, World world) {
        super(origin, size, world);
        this.clipboard = new CuboidClipboard(size, origin);
    }

    protected MCEditCuboidCopy(World world) {
        this.world = world;
    }

    public void save(File file) throws IOException, DataException {
        SchematicFormat.MCEDIT.save(this.clipboard, file);
    }

    protected void loadFromFile(File file) throws IOException, CuboidCopyException, DataException {
        this.clipboard = SchematicFormat.MCEDIT.load(file);
        this.origin = this.clipboard.getOrigin();
        this.size = this.clipboard.getSize();
        this.width = this.size.getBlockX();
        this.height = this.size.getBlockY();
        this.length = this.size.getBlockZ();
    }

    public void paste() {
        try {
            EditSession editSession = new EditSession((LocalWorld)new BukkitWorld(this.world), -1);
            editSession.enableQueue();
            this.clipboard.place(editSession, this.origin, false);
            editSession.flushQueue();
        }
        catch (MaxChangedBlocksException maxChangedBlocksException) {
            // empty catch block
        }
    }

    public void clear() {
        try {
            CuboidRegion region = new CuboidRegion(this.origin, this.origin.add(this.size.getX() - 1.0, this.size.getY() - 1.0, this.size.getZ() - 1.0));
            EditSession editSession = new EditSession((LocalWorld)new BukkitWorld(this.world), -1);
            editSession.enableQueue();
            editSession.setBlocks((Region)region, new BaseBlock(0));
            editSession.flushQueue();
        }
        catch (MaxChangedBlocksException maxChangedBlocksException) {
            // empty catch block
        }
    }

    public void copy() {
        EditSession editSession = new EditSession((LocalWorld)new BukkitWorld(this.world), -1);
        editSession.enableQueue();
        this.clipboard.copy(editSession);
        editSession.flushQueue();
    }
}

