/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.crafting;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.mech.crafting.CraftingItemStack;
import com.sk89q.craftbook.util.RegexUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipeManager
extends BaseConfiguration {
    public static RecipeManager INSTANCE;
    private Collection<Recipe> recipes;
    private File config;
    private File dataFolder;

    public RecipeManager(FileConfiguration cfg, File dataFolder) {
        super(cfg, dataFolder);
        INSTANCE = this;
        this.dataFolder = dataFolder;
    }

    public void load() {
        this.recipes = new ArrayList<Recipe>();
        this.config = new File(this.dataFolder, "crafting-recipes.yml");
        this.load(this.cfg.getConfigurationSection("crafting-recipes"));
    }

    public Collection<Recipe> getRecipes() {
        return this.recipes;
    }

    public boolean reload() {
        this.recipes.clear();
        this.load(YamlConfiguration.loadConfiguration((File)this.config).getConfigurationSection("crafting-recipes"));
        return true;
    }

    private void load(ConfigurationSection cfg) {
        if (cfg == null) {
            return;
        }
        Set keys = cfg.getKeys(false);
        if (keys != null) {
            for (String key : keys) {
                this.recipes.add(new Recipe(key, cfg));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Recipe {
        private final String id;
        private final ConfigurationSection config;
        private RecipeType type;
        private Collection<CraftingItemStack> ingredients;
        private HashMap<CraftingItemStack, Character> items;
        private Collection<CraftingItemStack> results;
        private List<String> shape;

        private Recipe(String id, ConfigurationSection cfg) {
            this.id = id;
            this.config = cfg.getConfigurationSection(id);
            this.ingredients = new ArrayList<CraftingItemStack>();
            this.results = new ArrayList<CraftingItemStack>();
            this.items = new HashMap();
            this.load();
        }

        private void load() {
            this.type = RecipeType.getTypeFromName(this.config.getString("type"));
            if (this.type != RecipeType.SHAPED2X2 && this.type != RecipeType.SHAPED3X3) {
                this.ingredients = this.getItems(this.config.getConfigurationSection("ingredients"));
            } else {
                this.items = this.getHashItems(this.config.getConfigurationSection("ingredients"));
                this.shape = this.config.getStringList("shape");
            }
            this.results = this.getItems(this.config.getConfigurationSection("results"));
        }

        private HashMap<CraftingItemStack, Character> getHashItems(ConfigurationSection section) {
            HashMap<CraftingItemStack, Character> items = new HashMap<CraftingItemStack, Character>();
            try {
                for (String item : section.getKeys(false)) {
                    Material material;
                    if (item == null || item.isEmpty()) continue;
                    String[] split = RegexUtil.COLON_PATTERN.split(item);
                    try {
                        material = Material.getMaterial((int)Integer.parseInt(split[0]));
                    }
                    catch (NumberFormatException e) {
                        material = Material.getMaterial((String)split[0].toUpperCase());
                    }
                    if (material == null) continue;
                    CraftingItemStack itemStack = new CraftingItemStack(material);
                    if (split.length > 1) {
                        itemStack.setData(Short.parseShort(split[1]));
                    } else {
                        itemStack.setData((short)0);
                    }
                    itemStack.setAmount(1);
                    items.put(itemStack, Character.valueOf(section.getString(item).toCharArray()[0]));
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("An error occured generating ingredients for recipe: " + section.getName());
            }
            return items;
        }

        private Collection<CraftingItemStack> getItems(ConfigurationSection section) {
            ArrayList<CraftingItemStack> items = new ArrayList<CraftingItemStack>();
            try {
                for (String item : section.getKeys(false)) {
                    Material material;
                    if (item == null || item.isEmpty()) continue;
                    String[] split = RegexUtil.COLON_PATTERN.split(item);
                    try {
                        material = Material.getMaterial((int)Integer.parseInt(split[0]));
                    }
                    catch (NumberFormatException e) {
                        material = Material.getMaterial((String)split[0].toUpperCase());
                    }
                    if (material == null) continue;
                    CraftingItemStack itemStack = new CraftingItemStack(material);
                    if (split.length > 1) {
                        itemStack.setData(Short.parseShort(split[1]));
                    } else {
                        itemStack.setData((short)0);
                    }
                    itemStack.setAmount(section.getInt(item, 1));
                    items.add(itemStack);
                }
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("An error occured generating ingredients for recipe: " + section.getName());
            }
            return items;
        }

        public String getId() {
            return this.id;
        }

        public RecipeType getType() {
            return this.type;
        }

        public Collection<CraftingItemStack> getIngredients() {
            return this.ingredients;
        }

        public String[] getShape() {
            return this.shape.toArray(new String[this.shape.size()]);
        }

        public HashMap<CraftingItemStack, Character> getShapedIngredients() {
            return this.items;
        }

        public CraftingItemStack getResult() {
            try {
                return this.results.iterator().next();
            }
            catch (Exception e) {
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum RecipeType {
            SHAPELESS("Shapeless"),
            SHAPED3X3("Shaped3x3"),
            SHAPED2X2("Shaped2x2"),
            FURNACE("Furnace");

            private String name;

            private RecipeType(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public static RecipeType getTypeFromName(String name) {
                for (RecipeType t : RecipeType.values()) {
                    if (!t.getName().equalsIgnoreCase(name)) continue;
                    return t;
                }
                return SHAPELESS;
            }
        }
    }
}

