/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.dispenser;

import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.mech.dispenser.Cannon;
import com.sk89q.craftbook.mech.dispenser.Fan;
import com.sk89q.craftbook.mech.dispenser.FireArrows;
import com.sk89q.craftbook.mech.dispenser.Recipe;
import com.sk89q.craftbook.mech.dispenser.SnowShooter;
import com.sk89q.craftbook.mech.dispenser.XPShooter;
import com.sk89q.craftbook.util.ItemUtil;
import java.util.ArrayList;
import org.bukkit.block.Dispenser;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DispenserRecipes
implements Listener {
    private final MechanismsPlugin plugin;
    private final ArrayList<Recipe> recipes = new ArrayList();

    public DispenserRecipes(MechanismsPlugin plugin) {
        this.plugin = plugin;
        this.addRecipe(new XPShooter());
        this.addRecipe(new SnowShooter());
        this.addRecipe(new FireArrows());
        this.addRecipe(new Fan());
        this.addRecipe(new Cannon());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent event) {
        if (this.plugin.getLocalConfiguration().dispenserSettings.enable) {
            if (!(event.getBlock().getState() instanceof Dispenser)) {
                return;
            }
            Dispenser dis = (Dispenser)event.getBlock().getState();
            if (this.dispenseNew(dis, event.getItem(), event.getVelocity(), event)) {
                event.setCancelled(true);
            }
        }
    }

    private boolean dispenseNew(Dispenser dis, ItemStack item, Vector velocity, BlockDispenseEvent event) {
        if (dis == null || dis.getInventory() == null || dis.getInventory().getContents() == null) {
            return false;
        }
        ItemStack[] stacks = dis.getInventory().getContents();
        for (Recipe r : this.recipes) {
            int[] recipe = r.getRecipe();
            if (!DispenserRecipes.checkRecipe(stacks, recipe)) continue;
            boolean toReturn = r.doAction(dis, item, velocity, event);
            for (int i = 0; i < stacks.length; ++i) {
                if (recipe[i] == 0) continue;
                stacks[i] = ItemUtil.getUsedItem((ItemStack)stacks[i]);
            }
            dis.getInventory().setContents(stacks);
            return toReturn;
        }
        return false;
    }

    private static boolean checkRecipe(ItemStack[] stacks, int[] recipe) {
        for (int i = 0; i < stacks.length; ++i) {
            int id;
            ItemStack stack = stacks[i];
            int n = id = stack == null ? 0 : stack.getTypeId();
            if (recipe[i] == id) continue;
            return false;
        }
        return true;
    }

    public boolean addRecipe(Recipe recipe) {
        if (recipe == null) {
            throw new NullPointerException("Dispenser recipe must not be null.");
        }
        if (this.recipes.contains(recipe)) {
            return false;
        }
        this.recipes.add(recipe);
        return true;
    }
}

