/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.GeneralUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class Chair
implements Listener {
    private boolean disabled = false;
    public ConcurrentHashMap<String, Block> chairs = new ConcurrentHashMap();
    private MechanismsPlugin plugin;

    public Chair(MechanismsPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)new ChairChecker(), 40L, 40L);
    }

    public void addChair(Player player, Block block) {
        if (this.disabled) {
            return;
        }
        try {
            PacketContainer entitymeta = this.plugin.getProtocolManager().createPacket(40);
            entitymeta.getSpecificModifier(Integer.TYPE).write(0, (Object)player.getEntityId());
            WrappedDataWatcher watcher = new WrappedDataWatcher();
            watcher.setObject(0, (Object)4);
            entitymeta.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
            for (Player play : this.plugin.getServer().getOnlinePlayers()) {
                if (!play.getWorld().equals(player.getPlayer().getWorld())) continue;
                try {
                    this.plugin.getProtocolManager().sendServerPacket(play, entitymeta);
                }
                catch (InvocationTargetException e) {
                    Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
                }
            }
        }
        catch (Error e) {
            Bukkit.getLogger().severe("Chairs do not work in this version of Minecraft!");
            this.disabled = true;
            return;
        }
        if (this.chairs.containsKey(player.getName())) {
            return;
        }
        this.plugin.wrap(player).print(ChatColor.YELLOW + "You are now sitting.");
        this.chairs.put(player.getName(), block);
    }

    public void removeChair(Player player) {
        if (this.disabled) {
            return;
        }
        PacketContainer entitymeta = this.plugin.getProtocolManager().createPacket(40);
        entitymeta.getSpecificModifier(Integer.TYPE).write(0, (Object)player.getEntityId());
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        watcher.setObject(0, (Object)0);
        entitymeta.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
        for (Player play : this.plugin.getServer().getOnlinePlayers()) {
            if (!play.getWorld().equals(player.getPlayer().getWorld())) continue;
            try {
                this.plugin.getProtocolManager().sendServerPacket(play, entitymeta);
            }
            catch (InvocationTargetException e) {
                Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
            }
        }
        this.plugin.wrap(player).print(ChatColor.YELLOW + "You are no longer sitting.");
        this.chairs.remove(player.getName());
    }

    public Block getChair(Player player) {
        if (this.disabled) {
            return null;
        }
        return this.chairs.get(player.getName());
    }

    public boolean hasChair(Player player) {
        return !this.disabled && this.chairs.containsKey(player.getName());
    }

    public boolean hasChair(Block player) {
        return !this.disabled && this.chairs.containsValue(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.hasChair(event.getPlayer())) {
            this.chairs.remove(event.getPlayer().getName());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.plugin.getLocalConfiguration().chairSettings.enable) {
            return;
        }
        if (this.hasChair(event.getBlock())) {
            event.setCancelled(true);
            this.plugin.wrap(event.getPlayer()).print("This seat is in use!");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().chairSettings.enable) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null || !this.plugin.getLocalConfiguration().chairSettings.canUseBlock(event.getClickedBlock().getTypeId())) {
            return;
        }
        BukkitPlayer player = new BukkitPlayer((BaseBukkitPlugin)this.plugin, event.getPlayer());
        if (player.getPlayer().getItemInHand() == null || !player.getPlayer().getItemInHand().getType().isBlock() || player.getPlayer().getItemInHand().getTypeId() == 0) {
            if (this.plugin.getLocalConfiguration().chairSettings.requireSneak != player.getPlayer().isSneaking()) {
                return;
            }
            if (!player.hasPermission("craftbook.mech.chair.use")) {
                player.printError("mech.use-permission");
                return;
            }
            if (this.hasChair(player.getPlayer())) {
                this.removeChair(player.getPlayer());
            } else {
                if (this.hasChair(event.getClickedBlock())) {
                    player.print("This seat is already occupied.");
                    return;
                }
                player.getPlayer().teleport(event.getClickedBlock().getLocation().add(0.5, 0.0, 0.5));
                this.addChair(player.getPlayer(), event.getClickedBlock());
            }
        }
    }

    public class ChairChecker
    implements Runnable {
        public void run() {
            for (String pl : Chair.this.chairs.keySet()) {
                Player p = Bukkit.getPlayer((String)pl);
                if (p == null) continue;
                if (!((Chair)Chair.this).plugin.getLocalConfiguration().chairSettings.canUseBlock(Chair.this.getChair(p).getTypeId()) || !p.getWorld().equals(Chair.this.getChair(p).getWorld()) || p.getLocation().distanceSquared(Chair.this.getChair(p).getLocation()) > 1.0) {
                    Chair.this.removeChair(p);
                    continue;
                }
                Chair.this.addChair(p, Chair.this.getChair(p));
                if (((Chair)Chair.this).plugin.getLocalConfiguration().chairSettings.healthRegen && p.getHealth() < 20) {
                    p.setHealth(p.getHealth() + 1);
                }
                if (!(p.getExhaustion() > -20.0f)) continue;
                p.setExhaustion(p.getExhaustion() - 0.1f);
            }
        }
    }
}

