/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public final class CustomDropManager {
    public static final int BLOCK_ID_COUNT = 256;
    public static final int DATA_VALUE_COUNT = 128;
    private static final Pattern COMMENT_PATTERN = Pattern.compile("#", 16);
    private static final Pattern FIELD_SEPARATOR_PATTERN = Pattern.compile("->", 16);
    private static final Pattern COLON_PATTERN = Pattern.compile(":", 16);
    private static final Pattern COMMA_PATTERN = Pattern.compile(",", 16);
    private static final Pattern X_PATTERN = Pattern.compile("x", 16);
    private static final Pattern MINUS_PATTERN = Pattern.compile("-", 16);
    private static final Pattern PERCENT_PATTERN = Pattern.compile("%", 16);
    private CustomItemDrop[] blockDropDefinitions = new CustomItemDrop[256];
    private Map<String, DropDefinition[]> mobDropDefinitions = new TreeMap<String, DropDefinition[]>();

    public CustomDropManager(File source) {
        File blockDefinitions = new File(source, "custom-block-drops.txt");
        File mobDefinitions = new File(source, "custom-mob-drops.txt");
        try {
            this.loadDropDefinitions(blockDefinitions, false);
        }
        catch (CustomDropParseException e) {
            Bukkit.getLogger().log(Level.WARNING, "Custom block drop definitions failed to parse", e);
        }
        catch (IOException e) {
            Bukkit.getLogger().log(Level.SEVERE, "Unknown IO error while loading custom block drop definitions", e);
        }
        catch (Exception e) {
            Bukkit.getLogger().log(Level.SEVERE, "Unknown exception while loading custom block drop definitions", e);
        }
        if (mobDefinitions.exists()) {
            try {
                this.loadDropDefinitions(mobDefinitions, true);
            }
            catch (CustomDropParseException e) {
                Bukkit.getLogger().log(Level.WARNING, "Custom mob drop definitions failed to parse", e);
            }
            catch (IOException e) {
                Bukkit.getLogger().log(Level.SEVERE, "Unknown IO error while loading custom mob drop definitions", e);
            }
            catch (Exception e) {
                Bukkit.getLogger().log(Level.SEVERE, "Unknown exception while loading custom mob drop definitions", e);
            }
        }
    }

    public CustomItemDrop getBlockDrops(int block) {
        if (block < 0 || block >= 256) {
            return null;
        }
        return this.blockDropDefinitions[block];
    }

    public DropDefinition[] getMobDrop(String mobName) {
        return this.mobDropDefinitions.get(mobName.toLowerCase());
    }

    public void loadDropDefinitions(File file, boolean isMobDrop) throws IOException {
        String prelude = "on unknown line";
        try {
            String line;
            CustomItemDrop[] blockDropDefinitions = isMobDrop ? null : new CustomItemDrop[256];
            TreeMap<String, DropDefinition[]> mobDropDefinitions = isMobDrop ? new TreeMap<String, DropDefinition[]>() : null;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int currentLine = 0;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || line.trim().startsWith("#")) continue;
                prelude = "Error on line " + ++currentLine + " of drop definition file " + file.getAbsolutePath() + ": " + line + "\n";
                try {
                    if (line.contains("#")) {
                        line = COMMENT_PATTERN.split(line)[0];
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if ((line = line.trim()).isEmpty()) continue;
                String[] split = FIELD_SEPARATOR_PATTERN.split(line, 2);
                if (split.length != 2) {
                    reader.close();
                    throw new CustomDropParseException(prelude + "-> not found");
                }
                String itemsSource = split[0].replace("+", "").trim();
                String targetDrops = split[1].trim();
                if (itemsSource.isEmpty() || targetDrops.isEmpty()) {
                    reader.close();
                    throw new CustomDropParseException(prelude + "unexpected empty field");
                }
                DropDefinition[] drops = CustomDropManager.readDrops(targetDrops, prelude, split[0].contains("+"));
                if (!isMobDrop) {
                    split = COLON_PATTERN.split(itemsSource);
                    if (split.length > 2) {
                        reader.close();
                        throw new CustomDropParseException(prelude + "too many source block fields");
                    }
                    int sourceId = Integer.parseInt(split[0]);
                    if (sourceId >= 256 || sourceId < 0) {
                        reader.close();
                        throw new CustomDropParseException(prelude + "block id out of range");
                    }
                    if (blockDropDefinitions[sourceId] == null) {
                        blockDropDefinitions[sourceId] = new CustomItemDrop();
                    }
                    CustomItemDrop drop = blockDropDefinitions[sourceId];
                    if (split.length == 1) {
                        if (drop.defaultDrop != null) {
                            reader.close();
                            throw new CustomDropParseException(prelude + "double drop definition");
                        }
                        drop.defaultDrop = drops;
                        continue;
                    }
                    int data = Integer.parseInt(split[1]);
                    if (data >= 128 || data < 0) {
                        reader.close();
                        throw new CustomDropParseException(prelude + "block data value out of range");
                    }
                    if (drop.drops[data] != null) {
                        reader.close();
                        throw new CustomDropParseException(prelude + "double drop definition");
                    }
                    drop.drops[data] = drops;
                    continue;
                }
                if (mobDropDefinitions.containsKey(itemsSource = itemsSource.toLowerCase())) {
                    reader.close();
                    throw new CustomDropParseException(prelude + "double drop definition");
                }
                mobDropDefinitions.put(itemsSource, drops);
            }
            reader.close();
            if (isMobDrop) {
                this.mobDropDefinitions = mobDropDefinitions;
            } else {
                this.blockDropDefinitions = blockDropDefinitions;
            }
        }
        catch (NumberFormatException e) {
            throw new CustomDropParseException(prelude + "number field failed to parse", e);
        }
    }

    private static DropDefinition[] readDrops(String s, String prelude, boolean append) throws IOException {
        String[] split = COMMA_PATTERN.split(s);
        DropDefinition[] drops = new DropDefinition[split.length];
        for (int i = 0; i < split.length; ++i) {
            drops[i] = CustomDropManager.readDrop(split[i].trim(), prelude, append);
        }
        return drops;
    }

    private static DropDefinition readDrop(String s, String prelude, boolean append) throws IOException {
        int data;
        String[] split = X_PATTERN.split(PERCENT_PATTERN.split(s)[0]);
        if (split.length > 2) {
            throw new CustomDropParseException(prelude + ": too many drop item fields");
        }
        String[] split2 = COLON_PATTERN.split(split[0].trim());
        if (split2.length > 2) {
            throw new CustomDropParseException(prelude + ": too many drop item fields");
        }
        int itemId = Integer.parseInt(split2[0].trim());
        int n = data = split2.length == 1 ? 0 : Integer.parseInt(split2[1].trim());
        if (data >= 128 || data < 0) {
            throw new CustomDropParseException(prelude + "block data value out of range");
        }
        String[] split3 = MINUS_PATTERN.split(split[1].trim());
        if (split3.length > 2) {
            throw new CustomDropParseException(prelude + ": invalid number drops range");
        }
        int countMin = Integer.parseInt(split3[0]);
        int countMax = split3.length == 1 ? countMin : Integer.parseInt(split3[1]);
        int chance = 100;
        try {
            chance = Integer.parseInt(PERCENT_PATTERN.split(s)[1]);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return new DropDefinition(itemId, (byte)data, countMin, countMax, chance, append);
    }

    public static class DropDefinition {
        public final int id;
        public final byte data;
        public final int countMin;
        public final int countMax;
        public final boolean append;
        public final int chance;

        public DropDefinition(int id, byte data, int countMin, int countMax, int chance, boolean append) {
            if (countMax < countMin) {
                int temp = countMin;
                countMin = countMax;
                countMax = temp;
            }
            if (chance < 0) {
                chance = 0;
            }
            if (chance > 100) {
                chance = 100;
            }
            this.chance = chance;
            this.id = id;
            this.data = data;
            this.countMin = countMin;
            this.countMax = countMax;
            this.append = append;
        }

        public ItemStack getItemStack() {
            if (MechanismsPlugin.random.nextInt(100) > this.chance) {
                return null;
            }
            return new ItemStack(this.id, this.countMin == this.countMax ? this.countMin : this.countMin + BaseBukkitPlugin.random.nextInt(this.countMax - this.countMin + 1), (short)this.data);
        }

        public ItemStack[] getItemStacks() {
            return null;
        }
    }

    public static class CustomItemDrop {
        public final DropDefinition[][] drops = new DropDefinition[128][];
        public DropDefinition[] defaultDrop;

        public DropDefinition[] getDrop(int data) {
            if (data < 0 || data >= 128) {
                return this.defaultDrop;
            }
            DropDefinition[] drop = this.drops[data];
            if (drop == null) {
                return this.defaultDrop;
            }
            return drop;
        }
    }

    public static class CustomDropParseException
    extends IOException {
        private static final long serialVersionUID = -1147409575702887124L;

        public CustomDropParseException(String message) {
            super(message);
        }

        public CustomDropParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

