/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Location;
import com.sk89q.worldedit.blocks.BlockType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.material.Button;

public class Elevator
extends AbstractMechanic {
    private final MechanismsPlugin plugin;
    private final Block trigger;
    private final BlockFace shift;
    private Block destination;

    private Elevator(Block trigger, Direction dir, MechanismsPlugin plugin) throws InvalidMechanismException {
        block6: {
            this.trigger = trigger;
            this.plugin = plugin;
            this.shift = dir == Direction.UP ? BlockFace.UP : BlockFace.DOWN;
            int f = dir == Direction.UP ? trigger.getWorld().getMaxHeight() : 0;
            this.destination = trigger;
            if (this.destination.getY() == f) {
                throw new InvalidConstructionException();
            }
            boolean loopd = false;
            while (true) {
                this.destination = this.destination.getRelative(this.shift);
                Direction derp = Elevator.isLift(this.destination);
                if (derp != Direction.NONE && Elevator.isValidLift(BukkitUtil.toChangedSign((Block)trigger), BukkitUtil.toChangedSign((Block)this.destination))) break block6;
                if (this.destination.getY() == trigger.getY()) {
                    throw new InvalidConstructionException();
                }
                if (plugin.getLocalConfiguration().elevatorSettings.loop && !loopd) {
                    org.bukkit.Location low;
                    if (this.destination.getY() == trigger.getWorld().getMaxHeight()) {
                        low = this.destination.getLocation();
                        low.setY(0.0);
                        this.destination = this.destination.getWorld().getBlockAt(low);
                        loopd = true;
                        continue;
                    }
                    if (this.destination.getY() != 0) continue;
                    low = this.destination.getLocation();
                    low.setY((double)trigger.getWorld().getMaxHeight());
                    this.destination = this.destination.getWorld().getBlockAt(low);
                    loopd = true;
                    continue;
                }
                if (this.destination.getY() == trigger.getWorld().getMaxHeight()) {
                    throw new InvalidConstructionException();
                }
                if (this.destination.getY() == 0) break;
            }
            throw new InvalidConstructionException();
        }
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().elevatorSettings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        LocalPlayer localPlayer = this.plugin.wrap(event.getPlayer());
        if (!localPlayer.hasPermission("craftbook.mech.elevator.use")) {
            event.setCancelled(true);
            localPlayer.printError("mech.use-permission");
            return;
        }
        this.makeItSo(this.plugin.wrap(event.getPlayer()));
        event.setCancelled(true);
    }

    private void makeItSo(LocalPlayer player) {
        Block floor = this.destination.getWorld().getBlockAt((int)Math.floor(player.getPosition().getPosition().getX()), this.destination.getY() + 1, (int)Math.floor(player.getPosition().getPosition().getZ()));
        if (!Elevator.occupiable(floor)) {
            floor = floor.getRelative(BlockFace.DOWN);
        }
        int foundFree = 0;
        boolean foundGround = false;
        for (int i = 0; i < 5; ++i) {
            if (Elevator.occupiable(floor)) {
                ++foundFree;
            } else {
                foundGround = true;
                break;
            }
            if (floor.getY() == 0) break;
            floor = floor.getRelative(BlockFace.DOWN);
        }
        if (!foundGround) {
            player.printError("mech.lift.no-floor");
            return;
        }
        if (foundFree < 2) {
            player.printError("mech.lift.obstruct");
            return;
        }
        Location newLocation = player.getPosition();
        newLocation = newLocation.setPosition(player.getPosition().getPosition().setY(floor.getY() + 1));
        if (player.isInsideVehicle()) {
            newLocation = player.getVehicle().getLocation();
            newLocation = newLocation.setPosition(player.getVehicle().getLocation().getPosition().setY(floor.getY() + 2));
            player.getVehicle().teleport(newLocation);
        }
        player.setPosition(newLocation.getPosition(), newLocation.getPitch(), newLocation.getYaw());
        if (!(this.destination.getState() instanceof Sign)) {
            return;
        }
        String title = ((Sign)this.destination.getState()).getLines()[0];
        if (!title.isEmpty()) {
            player.print(player.translate("mech.lift.floor") + ": " + title);
        } else {
            player.print("You went " + (this.shift.getModY() > 0 ? "up" : "down") + " a floor.");
        }
    }

    public static boolean isValidLift(ChangedSign start, ChangedSign stop) {
        if (start == null || stop == null) {
            return true;
        }
        if (start.getLine(2).toLowerCase().startsWith("to:")) {
            try {
                return stop.getLine(0).equalsIgnoreCase(start.getLine(2).split(":")[1].trim());
            }
            catch (Exception e) {
                start.setLine(2, "");
                return false;
            }
        }
        return true;
    }

    private static Direction isLift(Block block) {
        BlockState state = block.getState();
        if (!(state instanceof Sign)) {
            Button b;
            Block sign;
            if (MechanismsPlugin.getInst().getLocalConfiguration().elevatorSettings.buttons && (block.getTypeId() == 77 || block.getTypeId() == 143) && (sign = block.getRelative((b = (Button)block.getState().getData()).getAttachedFace()).getRelative(b.getAttachedFace())).getState() instanceof Sign) {
                return Elevator.isLift(BukkitUtil.toChangedSign((Sign)((Sign)sign.getState()), (String[])((Sign)sign.getState()).getLines()));
            }
            return Direction.NONE;
        }
        return Elevator.isLift(BukkitUtil.toChangedSign((Sign)((Sign)state), (String[])((Sign)state).getLines()));
    }

    private static Direction isLift(ChangedSign sign) {
        if (sign.getLine(1).equalsIgnoreCase("[Lift Up]")) {
            return Direction.UP;
        }
        if (sign.getLine(1).equalsIgnoreCase("[Lift Down]")) {
            return Direction.DOWN;
        }
        if (sign.getLine(1).equalsIgnoreCase("[Lift]")) {
            return Direction.RECV;
        }
        return Direction.NONE;
    }

    private static boolean occupiable(Block block) {
        return BlockType.canPassThrough((int)block.getTypeId());
    }

    private static class InvalidConstructionException
    extends InvalidMechanismException {
        private static final long serialVersionUID = 2306504048848430689L;

        public InvalidConstructionException() {
            super("This lift has no destination.");
        }
    }

    private static class NoDepartureException
    extends InvalidMechanismException {
        private static final long serialVersionUID = 3845311158458450314L;

        public NoDepartureException() {
            super("Cannot depart from this lift (can only arrive).");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        NONE,
        UP,
        DOWN,
        RECV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Elevator> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Elevator detect(BlockWorldVector pt) throws InvalidMechanismException {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            Direction dir = Elevator.isLift(block);
            switch (dir) {
                case UP: 
                case DOWN: {
                    return new Elevator(block, dir, this.plugin);
                }
                case RECV: {
                    throw new NoDepartureException();
                }
            }
            return null;
        }

        public Elevator detect(BlockWorldVector pt, LocalPlayer player, ChangedSign sign) throws InvalidMechanismException, ProcessedMechanismException {
            Direction dir = Elevator.isLift(sign);
            switch (dir) {
                case UP: {
                    player.checkPermission("craftbook.mech.elevator");
                    player.print("mech.lift.up-sign-created");
                    sign.setLine(1, "[Lift Up]");
                    break;
                }
                case DOWN: {
                    player.checkPermission("craftbook.mech.elevator");
                    player.print("mech.lift.down-sign-created");
                    sign.setLine(1, "[Lift Down]");
                    break;
                }
                case RECV: {
                    player.checkPermission("craftbook.mech.elevator");
                    player.print("mech.lift.target-sign-created");
                    sign.setLine(1, "[Lift]");
                    break;
                }
                default: {
                    return null;
                }
            }
            throw new ProcessedMechanismException();
        }
    }
}

