/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class XPStorer
extends AbstractMechanic {
    MechanismsPlugin plugin;

    private XPStorer(BlockWorldVector pt, MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.wrap(event.getPlayer()).hasPermission("craftbook.mech.xpstore.use")) {
            return;
        }
        if (event.getPlayer().isSneaking() || event.getPlayer().getLevel() < 1) {
            return;
        }
        int xp = 0;
        event.getPlayer().setExp(0.0f);
        while (event.getPlayer().getLevel() > 0) {
            event.getPlayer().setLevel(event.getPlayer().getLevel() - 1);
            xp += event.getPlayer().getExpToLevel();
        }
        if (xp < 16) {
            event.getPlayer().giveExp(xp);
            return;
        }
        event.getClickedBlock().getWorld().dropItemNaturally(event.getClickedBlock().getLocation(), new ItemStack(384, xp / 16));
        event.getPlayer().setLevel(0);
        event.getPlayer().setExp(0.0f);
        event.setCancelled(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<XPStorer> {
        MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public XPStorer detect(BlockWorldVector pt) {
            int type = BukkitUtil.toWorld((WorldVector)pt).getBlockTypeIdAt(BukkitUtil.toLocation((WorldVector)pt));
            if (type == this.plugin.getLocalConfiguration().xpStorerSettings.material) {
                return new XPStorer(pt, this.plugin);
            }
            return null;
        }
    }
}

