/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.crafting;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CraftingItemStack
implements Comparable<CraftingItemStack> {
    private static final Pattern COLON_PATTERN = Pattern.compile(":", 16);
    private Material material;
    private short data;
    private int amount;

    public static Collection<CraftingItemStack> convert(Collection<Item> stacks) {
        HashMap<String, Integer> items = new HashMap<String, Integer>();
        for (Item item : stacks) {
            ItemStack stack = item.getItemStack();
            String name = stack.getType() + ":" + stack.getDurability();
            if (items.containsKey(name)) {
                items.put(name, (Integer)items.get(name) + stack.getAmount());
                continue;
            }
            items.put(name, stack.getAmount());
        }
        LinkedHashSet<CraftingItemStack> stackSet = new LinkedHashSet<CraftingItemStack>();
        for (Map.Entry entry : items.entrySet()) {
            String[] split = COLON_PATTERN.split((CharSequence)entry.getKey());
            stackSet.add(new CraftingItemStack(Material.getMaterial((String)split[0]), Short.parseShort(split[1]), (Integer)entry.getValue()));
        }
        return stackSet;
    }

    public CraftingItemStack(Material material, short data, int amount) {
        this.material = material;
        this.data = data;
        this.amount = amount;
    }

    public CraftingItemStack(Material material, int amount) {
        this.material = material;
        this.amount = amount;
        this.data = 0;
    }

    public CraftingItemStack(Material material, short data) {
        this(material, data, 0);
    }

    public CraftingItemStack(Material material) {
        this(material, 0);
    }

    public Material getMaterial() {
        return this.material;
    }

    public short getData() {
        return this.data;
    }

    public int getAmount() {
        if (this.amount < 1) {
            return 1;
        }
        return this.amount;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setData(short data) {
        this.data = data;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.material, this.amount, this.data);
    }

    public CraftingItemStack add(CraftingItemStack stack) {
        if (stack.equals(this)) {
            this.amount += stack.getAmount();
        }
        return this;
    }

    public boolean isSameType(CraftingItemStack stack) {
        if (this.data == -1 || stack.getData() == -1) {
            return stack.getMaterial() == this.getMaterial();
        }
        return stack.getMaterial() == this.getMaterial() && stack.getData() == this.getData();
    }

    @Override
    public int compareTo(CraftingItemStack stack) {
        if (this.getAmount() > stack.getAmount()) {
            return 1;
        }
        if (this.getAmount() == stack.getAmount()) {
            return 0;
        }
        return -1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.amount;
        result = 31 * result + this.data;
        result = 31 * result + (this.material == null ? 0 : this.material.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CraftingItemStack) {
            CraftingItemStack stack = (CraftingItemStack)obj;
            return this.isSameType(stack) && stack.getAmount() == this.getAmount();
        }
        return false;
    }
}

