/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.cart;

import com.sk89q.craftbook.bukkit.VehiclesPlugin;
import com.sk89q.craftbook.cart.CartMechanism;
import com.sk89q.craftbook.cart.CartMechanismBlocks;
import com.sk89q.craftbook.util.SignUtil;
import java.util.regex.Pattern;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CartSorter
extends CartMechanism {
    private static final Pattern COLON_PATTERN = Pattern.compile(":", 16);

    public void impact(Minecart cart, CartMechanismBlocks blocks, boolean minor) {
        byte trackData;
        if (minor) {
            return;
        }
        if (cart == null) {
            return;
        }
        if (!blocks.matches("sort")) {
            return;
        }
        Sign sign = (Sign)blocks.sign.getState();
        Hand dir = Hand.STRAIGHT;
        if (CartSorter.isSortApplicable(sign.getLine(2), cart)) {
            dir = Hand.LEFT;
        } else if (CartSorter.isSortApplicable(sign.getLine(3), cart)) {
            dir = Hand.RIGHT;
        }
        BlockFace next = SignUtil.getFacing((Block)blocks.sign);
        block0 : switch (next) {
            case WEST: {
                switch (dir) {
                    case LEFT: {
                        trackData = 9;
                        break block0;
                    }
                    case RIGHT: {
                        trackData = 8;
                        break block0;
                    }
                }
                trackData = 0;
                break;
            }
            case EAST: {
                switch (dir) {
                    case LEFT: {
                        trackData = 7;
                        break block0;
                    }
                    case RIGHT: {
                        trackData = 6;
                        break block0;
                    }
                }
                trackData = 0;
                break;
            }
            case NORTH: {
                switch (dir) {
                    case LEFT: {
                        trackData = 6;
                        break block0;
                    }
                    case RIGHT: {
                        trackData = 9;
                        break block0;
                    }
                }
                trackData = 1;
                break;
            }
            case SOUTH: {
                switch (dir) {
                    case LEFT: {
                        trackData = 8;
                        break block0;
                    }
                    case RIGHT: {
                        trackData = 7;
                        break block0;
                    }
                }
                trackData = 1;
                break;
            }
            default: {
                return;
            }
        }
        Block targetTrack = blocks.rail.getRelative(next);
        if (targetTrack.getTypeId() == 66) {
            targetTrack.setData(trackData);
        }
    }

    public static boolean isSortApplicable(String line, Minecart minecart) {
        if (line.equalsIgnoreCase("All")) {
            return true;
        }
        Entity test = minecart.getPassenger();
        Player player = null;
        if (test instanceof Player) {
            player = (Player)test;
        }
        if ((line.equalsIgnoreCase("Unoccupied") || line.equalsIgnoreCase("Empty")) && minecart.getPassenger() == null) {
            return true;
        }
        if (line.equalsIgnoreCase("Storage") && minecart instanceof StorageMinecart) {
            return true;
        }
        if (line.equalsIgnoreCase("Powered") && minecart instanceof PoweredMinecart) {
            return true;
        }
        if (line.equalsIgnoreCase("Minecart") && minecart instanceof Minecart) {
            return true;
        }
        if ((line.equalsIgnoreCase("Occupied") || line.equalsIgnoreCase("Full")) && minecart.getPassenger() != null) {
            return true;
        }
        if (line.equalsIgnoreCase("Animal") && test instanceof Animals) {
            return true;
        }
        if (line.equalsIgnoreCase("Mob") && test instanceof Monster) {
            return true;
        }
        if ((line.equalsIgnoreCase("Player") || line.equalsIgnoreCase("Ply")) && player != null) {
            return true;
        }
        String[] parts = COLON_PATTERN.split(line);
        if (parts.length >= 2) {
            if (player != null && parts[0].equalsIgnoreCase("Held")) {
                try {
                    int item = Integer.parseInt(parts[1]);
                    if (player.getItemInHand().getTypeId() == item) {
                        return true;
                    }
                }
                catch (NumberFormatException ignored) {}
            } else if (player != null && parts[0].equalsIgnoreCase("Ply")) {
                if (parts[1].equalsIgnoreCase(player.getName())) {
                    return true;
                }
            } else {
                if (parts[0].equalsIgnoreCase("Mob")) {
                    String testMob = parts[1];
                    return test.getType().toString().equalsIgnoreCase(testMob);
                }
                if (minecart instanceof StorageMinecart && parts[0].equalsIgnoreCase("Ctns")) {
                    StorageMinecart storageCart = (StorageMinecart)minecart;
                    Inventory storageInventory = storageCart.getInventory();
                    if (parts.length == 4) {
                        try {
                            int item = Integer.parseInt(parts[1]);
                            short durability = Short.parseShort(parts[2]);
                            int index = Math.min(Math.max(Integer.parseInt(parts[3]) - 1, 0), storageInventory.getContents().length - 1);
                            ItemStack indexed = storageInventory.getContents()[index];
                            if (indexed != null && indexed.equals((Object)new ItemStack(item, 1, durability))) {
                                return true;
                            }
                        }
                        catch (NumberFormatException ignored) {}
                    } else if (parts.length == 3) {
                        try {
                            int item = Integer.parseInt(parts[1]);
                            short durability = Short.parseShort(parts[2]);
                            if (storageInventory.contains(new ItemStack(item, 1, durability))) {
                                return true;
                            }
                        }
                        catch (NumberFormatException ignored) {}
                    } else {
                        try {
                            int item = Integer.parseInt(parts[1]);
                            if (storageInventory.contains(item)) {
                                return true;
                            }
                        }
                        catch (NumberFormatException ignored) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (line.startsWith("#") && player != null) {
            String selectedStation = VehiclesPlugin.getInstance().getStation(player.getName());
            return line.equalsIgnoreCase("#" + selectedStation);
        }
        return false;
    }

    public String getName() {
        return "Sorter";
    }

    public String[] getApplicableSigns() {
        return new String[]{"Sort"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Hand {
        STRAIGHT,
        LEFT,
        RIGHT;

    }
}

