/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric.handler;

import com.sk89q.intake.Command;
import com.sk89q.intake.CommandException;
import com.sk89q.intake.SettableDescription;
import com.sk89q.intake.context.CommandContext;
import com.sk89q.intake.parametric.MissingParameterException;
import com.sk89q.intake.parametric.ParameterData;
import com.sk89q.intake.parametric.ParameterException;
import com.sk89q.intake.parametric.UnconsumedParameterException;
import com.sk89q.intake.parametric.binding.BindingBehavior;
import com.sk89q.intake.parametric.handler.AbstractInvokeListener;
import com.sk89q.intake.parametric.handler.InvokeHandler;
import java.lang.reflect.Method;

public class LegacyCommandsHandler
extends AbstractInvokeListener
implements InvokeHandler {
    @Override
    public InvokeHandler createInvokeHandler() {
        return this;
    }

    @Override
    public void preProcess(Object object, Method method, ParameterData[] parameters, CommandContext context) throws CommandException, ParameterException {
    }

    @Override
    public void preInvoke(Object object, Method method, ParameterData[] parameters, Object[] args, CommandContext context) throws ParameterException {
        Command annotation = method.getAnnotation(Command.class);
        if (annotation != null) {
            if (context.argsLength() < annotation.min()) {
                throw new MissingParameterException();
            }
            if (annotation.max() != -1 && context.argsLength() > annotation.max()) {
                throw new UnconsumedParameterException(context.getRemainingString(annotation.max()));
            }
        }
    }

    @Override
    public void postInvoke(Object object, Method method, ParameterData[] parameters, Object[] args, CommandContext context) {
    }

    @Override
    public void updateDescription(Object object, Method method, ParameterData[] parameters, SettableDescription description) {
        Command annotation = method.getAnnotation(Command.class);
        if (annotation != null && annotation.usage().isEmpty() && (annotation.min() > 0 || annotation.max() > 0)) {
            boolean hasUserParameters = false;
            for (ParameterData parameter : parameters) {
                if (parameter.getBinding().getBehavior(parameter) == BindingBehavior.PROVIDES) continue;
                hasUserParameters = true;
                break;
            }
            if (!hasUserParameters) {
                description.overrideUsage("(unknown usage information)");
            }
        }
    }
}

