/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sk89q.intake.Parameter;
import com.sk89q.intake.parametric.ParameterData;
import com.sk89q.intake.parametric.ParametricBuilder;
import com.sk89q.intake.parametric.ParametricException;
import com.sk89q.intake.parametric.annotation.Optional;
import com.sk89q.intake.parametric.annotation.Switch;
import com.sk89q.intake.parametric.binding.Binding;
import com.sk89q.intake.parametric.binding.BindingBehavior;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

public class ParameterBinder<T> {
    private final ParametricBuilder builder;
    private final List<ParameterData<T>> parameters = Lists.newArrayList();
    private final List<Parameter> userProvidedParameters = Lists.newArrayList();
    private final Set<Character> valueFlags = Sets.newHashSet();
    private int optionalParamCount = 0;

    public ParameterBinder(ParametricBuilder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"builder");
        this.builder = builder;
    }

    public void addParameter(Type type, Annotation[] annotations, T target) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkNotNull((Object)annotations, (Object)"annotations");
        int index = this.parameters.size();
        Binding binding = null;
        ParameterData<T> parameter = new ParameterData<T>(target);
        parameter.setName(ParameterBinder.getFriendlyName(type, parameter.getClassifier(), index));
        parameter.setType(type);
        parameter.setModifiers(annotations);
        for (Annotation annotation : annotations) {
            if (annotation instanceof Switch) {
                parameter.setFlag(Character.valueOf(((Switch)annotation).value()), type != Boolean.TYPE);
                continue;
            }
            if (annotation instanceof Optional) {
                parameter.setOptional(true);
                String[] value = ((Optional)annotation).value();
                if (value.length <= 0) continue;
                parameter.setDefaultValue(value);
                continue;
            }
            if (parameter.getBinding() != null) continue;
            binding = this.builder.getBindings().get(annotation.annotationType());
            parameter.setClassifier(annotation);
        }
        if (parameter.isValueFlag()) {
            this.valueFlags.add(parameter.getFlag());
        }
        if (binding == null) {
            binding = this.builder.getBindings().get(type);
        }
        if (binding == null) {
            throw new ParametricException("Can't finding a binding for the parameter type '" + type + "' in\n" + target);
        }
        parameter.setBinding(binding);
        ParameterBinder.validate(parameter, target, index + 1);
        if (parameter.isOptional() && parameter.getFlag() == null) {
            ++this.optionalParamCount;
        } else if (this.optionalParamCount > 0 && parameter.isNonFlagConsumer() && parameter.getConsumedCount() < 0) {
            throw new ParametricException("Found an parameter using the binding " + parameter.getBinding().getClass().getCanonicalName() + "\nthat does not know how many arguments it consumes, but " + "it follows an optional parameter\nMethod: " + target);
        }
        this.parameters.add(parameter);
        if (parameter.isUserInput()) {
            this.userProvidedParameters.add(parameter);
        }
    }

    public ImmutableList<ParameterData<T>> getParameters() {
        return ImmutableList.copyOf(this.parameters);
    }

    public ImmutableList<Parameter> getUserProvidedParameters() {
        return ImmutableList.copyOf(this.userProvidedParameters);
    }

    private static String getFriendlyName(Type type, Annotation classifier, int index) {
        if (classifier != null) {
            return classifier.annotationType().getSimpleName().toLowerCase();
        }
        return type instanceof Class ? ((Class)type).getSimpleName().toLowerCase() : "unknown" + index;
    }

    private static void validate(ParameterData<?> parameter, Object target, int parameterIndex) throws ParametricException {
        boolean indeterminate;
        Binding binding = parameter.getBinding();
        BindingBehavior behavior = parameter.getBinding().getBehavior(parameter);
        boolean bl = indeterminate = behavior == BindingBehavior.INDETERMINATE;
        if (!parameter.isValueFlag() && indeterminate) {
            throw new ParametricException("@Switch missing for indeterminate consumer\n\nNotably:\nFor the type " + parameter.getType() + ", the binding " + binding.getClass().getCanonicalName() + "\nmay or may not consume parameters (isIndeterminateConsumer(" + parameter.getType() + ") = true)" + "\nand therefore @Switch(flag) is required for parameter #" + parameterIndex + " of \n" + target);
        }
        if (behavior != BindingBehavior.CONSUMES && binding.getConsumedCount(parameter) != -1) {
            throw new ParametricException("getConsumedCount() does not return -1 for binding " + binding.getClass().getCanonicalName() + "\neven though its behavior type is " + behavior.name() + "\nfor parameter #" + parameterIndex + " of \n" + target);
        }
        if (behavior != BindingBehavior.PROVIDES && binding.getConsumedCount(parameter) == 0) {
            throw new ParametricException("getConsumedCount() must not return 0 for binding " + binding.getClass().getCanonicalName() + "\nwhen its behavior type is " + behavior.name() + " and not PROVIDES " + "\nfor parameter #" + parameterIndex + " of \n" + target);
        }
    }
}

