/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Chars;
import com.sk89q.intake.Command;
import com.sk89q.intake.CommandCallable;
import com.sk89q.intake.CommandException;
import com.sk89q.intake.InvalidUsageException;
import com.sk89q.intake.InvocationCommandException;
import com.sk89q.intake.Parameter;
import com.sk89q.intake.Require;
import com.sk89q.intake.SettableDescription;
import com.sk89q.intake.context.CommandContext;
import com.sk89q.intake.context.CommandLocals;
import com.sk89q.intake.parametric.ConsumeException;
import com.sk89q.intake.parametric.MissingParameterException;
import com.sk89q.intake.parametric.ParameterBinder;
import com.sk89q.intake.parametric.ParameterConsumer;
import com.sk89q.intake.parametric.ParameterData;
import com.sk89q.intake.parametric.ParametricBuilder;
import com.sk89q.intake.parametric.ParametricException;
import com.sk89q.intake.parametric.UnconsumedParameterException;
import com.sk89q.intake.parametric.handler.ExceptionConverter;
import com.sk89q.intake.parametric.handler.InvokeHandler;
import com.sk89q.intake.parametric.handler.InvokeListener;
import com.sk89q.intake.util.auth.AuthorizationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class ParametricCallable
implements CommandCallable {
    private final ParametricBuilder builder;
    private final Object object;
    private final Method method;
    private final ImmutableList<? extends ParameterData<?>> parameters;
    private final Set<Character> valueFlags = new HashSet<Character>();
    private final boolean ignoreUnusedFlags;
    private final Set<Character> unusedFlags = new HashSet<Character>();
    private final SettableDescription description = new SettableDescription();
    private final Require permission;

    ParametricCallable(ParametricBuilder builder, Object object, Method method, Command definition) throws ParametricException {
        Preconditions.checkNotNull((Object)builder, (Object)"builder");
        Preconditions.checkNotNull((Object)object, (Object)"object");
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkNotNull((Object)definition, (Object)"definition");
        this.builder = builder;
        this.object = object;
        this.method = method;
        Annotation[][] annotations = method.getParameterAnnotations();
        Type[] types = method.getGenericParameterTypes();
        ParameterBinder<Method> inspector = new ParameterBinder<Method>(builder);
        for (int i = 0; i < types.length; ++i) {
            inspector.addParameter(types[i], annotations[i], method);
        }
        this.parameters = inspector.getParameters();
        this.ignoreUnusedFlags = definition.anyFlags();
        this.unusedFlags.addAll(Chars.asList((char[])definition.flags().toCharArray()));
        Require permHint = method.getAnnotation(Require.class);
        if (permHint != null) {
            this.description.setPermissions(Arrays.asList(permHint.value()));
        }
        this.description.setParameters((List<Parameter>)inspector.getUserProvidedParameters());
        this.description.setDescription(!definition.desc().isEmpty() ? definition.desc() : null);
        this.description.setHelp(!definition.help().isEmpty() ? definition.help() : null);
        this.description.overrideUsage(!definition.usage().isEmpty() ? definition.usage() : null);
        for (InvokeListener listener : builder.getInvokeListeners()) {
            listener.updateDescription(object, method, this.parameters, this.description);
        }
        this.permission = method.getAnnotation(Require.class);
    }

    @Override
    public boolean call(String stringArguments, CommandLocals locals, String[] parentCommands) throws CommandException, AuthorizationException {
        if (!this.testPermission(locals)) {
            throw new AuthorizationException();
        }
        String calledCommand = parentCommands.length > 0 ? parentCommands[parentCommands.length - 1] : "_";
        String[] split = CommandContext.split(calledCommand + " " + stringArguments);
        CommandContext context = new CommandContext(split, this.getValueFlags(), false, locals);
        if (context.hasFlag('?')) {
            throw new InvalidUsageException(null, this, true);
        }
        try {
            boolean invoke = true;
            ArrayList<InvokeHandler> handlers = new ArrayList<InvokeHandler>();
            for (InvokeListener invokeListener : this.builder.getInvokeListeners()) {
                InvokeHandler handler = invokeListener.createInvokeHandler();
                handlers.add(handler);
                if (handler.preProcess(this.object, this.method, this.parameters, context, locals)) continue;
                invoke = false;
            }
            if (!invoke) {
                return true;
            }
            ParameterConsumer consumer = new ParameterConsumer((List<? extends ParameterData<?>>)this.parameters);
            final Object[] args = consumer.parseArguments(context, this.ignoreUnusedFlags, this.unusedFlags);
            for (InvokeHandler handler : handlers) {
                if (handler.preInvoke(this.object, this.method, this.parameters, args, context, locals)) continue;
                invoke = false;
            }
            if (!invoke) {
                return true;
            }
            try {
                this.builder.getCommandExecutor().submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ParametricCallable.this.method.invoke(ParametricCallable.this.object, args);
                    }
                }).get();
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
            for (InvokeHandler handler : handlers) {
                handler.postInvoke(handler, this.method, this.parameters, args, context, locals);
            }
        }
        catch (MissingParameterException ignored) {
            throw new InvalidUsageException("Too few parameters!", this);
        }
        catch (UnconsumedParameterException e) {
            throw new InvalidUsageException("Too many parameters! Unused parameters: " + e.getUnconsumed(), this);
        }
        catch (ConsumeException e) {
            throw new InvalidUsageException("For parameter '" + e.getParameter().getName() + "': " + e.getMessage(), this);
        }
        catch (InvocationTargetException e) {
            for (ExceptionConverter converter : this.builder.getExceptionConverters()) {
                converter.convert(e.getCause());
            }
            throw new InvocationCommandException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationCommandException(e);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvocationCommandException(e);
        }
        return true;
    }

    @Override
    public List<String> getSuggestions(String arguments, CommandLocals locals) throws CommandException {
        return this.builder.getDefaultCompleter().getSuggestions(arguments, locals);
    }

    public Set<Character> getValueFlags() {
        return this.valueFlags;
    }

    @Override
    public SettableDescription getDescription() {
        return this.description;
    }

    @Override
    public boolean testPermission(CommandLocals locals) {
        if (this.permission != null) {
            for (String perm : this.permission.value()) {
                if (!this.builder.getAuthorizer().testPermission(locals, perm)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String generateName(Type type, Annotation classifier, int index) {
        if (classifier != null) {
            return classifier.annotationType().getSimpleName().toLowerCase();
        }
        if (type instanceof Class) {
            return ((Class)type).getSimpleName().toLowerCase();
        }
        return "unknown" + index;
    }
}

