/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sk89q.intake.CommandCallable;
import com.sk89q.intake.CommandException;
import com.sk89q.intake.InvalidUsageException;
import com.sk89q.intake.InvocationCommandException;
import com.sk89q.intake.context.CommandContext;
import com.sk89q.intake.context.CommandLocals;
import com.sk89q.intake.parametric.ConsumeException;
import com.sk89q.intake.parametric.MissingParameterException;
import com.sk89q.intake.parametric.ParameterConsumer;
import com.sk89q.intake.parametric.ParameterData;
import com.sk89q.intake.parametric.ParametricBuilder;
import com.sk89q.intake.parametric.UnconsumedParameterException;
import com.sk89q.intake.parametric.handler.ExceptionConverter;
import com.sk89q.intake.parametric.handler.InvokeHandler;
import com.sk89q.intake.parametric.handler.InvokeListener;
import com.sk89q.intake.util.auth.AuthorizationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public abstract class AbstractParametricCommand
implements CommandCallable {
    private final ParametricBuilder builder;
    private ImmutableList<? extends ParameterData<?>> parameters = ImmutableList.of();
    private ImmutableList<String> permissions = ImmutableList.of();
    private ImmutableSet<Character> valueFlags = ImmutableSet.of();
    private boolean ignoreUnusedFlags = false;
    private ImmutableSet<Character> unusedFlags = ImmutableSet.of();
    private ImmutableSet<Annotation> annotations = ImmutableSet.of();

    protected AbstractParametricCommand(ParametricBuilder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"builder");
        this.builder = builder;
    }

    protected ParametricBuilder getBuilder() {
        return this.builder;
    }

    protected List<? extends ParameterData<?>> getParameters() {
        return this.parameters;
    }

    protected List<String> getPermissions() {
        return this.permissions;
    }

    protected void setParameters(List<? extends ParameterData<?>> parameters) {
        this.parameters = ImmutableList.copyOf(parameters);
    }

    protected void setPermissions(List<String> permissions) {
        this.permissions = ImmutableList.copyOf(permissions);
    }

    protected Set<Character> getValueFlags() {
        return this.valueFlags;
    }

    protected void setValueFlags(Set<Character> valueFlags) {
        this.valueFlags = ImmutableSet.copyOf(valueFlags);
    }

    protected boolean getIgnoreUnusedFlags() {
        return this.ignoreUnusedFlags;
    }

    protected void setIgnoreUnusedFlags(boolean ignoreUnusedFlags) {
        this.ignoreUnusedFlags = ignoreUnusedFlags;
    }

    protected Set<Character> getUnusedFlags() {
        return this.unusedFlags;
    }

    protected void setUnusedFlags(Set<Character> unusedFlags) {
        this.unusedFlags = ImmutableSet.copyOf(unusedFlags);
    }

    public ImmutableSet<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = ImmutableSet.copyOf(annotations);
    }

    @Override
    public final boolean call(String stringArguments, CommandLocals locals, String[] parentCommands) throws CommandException, AuthorizationException {
        if (!this.testPermission(locals)) {
            throw new AuthorizationException();
        }
        String calledCommand = parentCommands.length > 0 ? parentCommands[parentCommands.length - 1] : "_";
        String[] split = CommandContext.split(calledCommand + " " + stringArguments);
        CommandContext context = new CommandContext(split, (Set<Character>)this.valueFlags, false, locals);
        if (context.hasFlag('?')) {
            throw new InvalidUsageException(null, this, true);
        }
        try {
            boolean invoke = true;
            ArrayList<InvokeHandler> handlers = new ArrayList<InvokeHandler>();
            for (InvokeListener invokeListener : this.getBuilder().getInvokeListeners()) {
                InvokeHandler handler = invokeListener.createInvokeHandler();
                handlers.add(handler);
                if (handler.preProcess((Set<Annotation>)this.getAnnotations(), this.getParameters(), context)) continue;
                invoke = false;
            }
            if (!invoke) {
                return true;
            }
            ParameterConsumer consumer = new ParameterConsumer((List<? extends ParameterData<?>>)this.parameters);
            final Object[] args = consumer.parseArguments(context, this.ignoreUnusedFlags, (Set<Character>)this.unusedFlags);
            for (InvokeHandler handler : handlers) {
                if (handler.preInvoke((Set<Annotation>)this.getAnnotations(), (List<? extends ParameterData<?>>)this.parameters, args, context)) continue;
                invoke = false;
            }
            if (!invoke) {
                return true;
            }
            try {
                this.builder.getCommandExecutor().submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        AbstractParametricCommand.this.call(args);
                        return null;
                    }
                }).get();
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
            for (InvokeHandler handler : handlers) {
                handler.postInvoke((Set<Annotation>)this.getAnnotations(), (List<? extends ParameterData<?>>)this.parameters, args, context);
            }
        }
        catch (MissingParameterException ignored) {
            throw new InvalidUsageException("Too few parameters!", this);
        }
        catch (UnconsumedParameterException e) {
            throw new InvalidUsageException("Too many parameters! Unused parameters: " + e.getUnconsumed(), this);
        }
        catch (ConsumeException e) {
            throw new InvalidUsageException("For parameter '" + e.getParameter().getName() + "': " + e.getMessage(), this);
        }
        catch (InvocationTargetException e) {
            for (ExceptionConverter converter : this.builder.getExceptionConverters()) {
                converter.convert(e.getCause());
            }
            throw new InvocationCommandException(e);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationCommandException(e);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InvocationCommandException(e);
        }
        return true;
    }

    protected abstract void call(Object[] var1) throws Exception;

    @Override
    public boolean testPermission(CommandLocals locals) {
        for (String perm : this.permissions) {
            if (!this.builder.getAuthorizer().testPermission(locals, perm)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getSuggestions(String arguments, CommandLocals locals) throws CommandException {
        return this.builder.getDefaultCompleter().getSuggestions(arguments, locals);
    }
}

