/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sk89q.intake.CommandException;
import com.sk89q.intake.Parameter;
import com.sk89q.intake.context.CommandContext;
import com.sk89q.intake.parametric.ConsumeException;
import com.sk89q.intake.parametric.MissingParameterException;
import com.sk89q.intake.parametric.ParameterData;
import com.sk89q.intake.parametric.ParameterException;
import com.sk89q.intake.parametric.ParametricException;
import com.sk89q.intake.parametric.UnconsumedParameterException;
import com.sk89q.intake.parametric.argument.ArgumentStack;
import com.sk89q.intake.parametric.argument.ContextArgumentStack;
import com.sk89q.intake.parametric.argument.StringArgumentStack;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ParameterConsumer {
    private final ImmutableList<? extends ParameterData<?>> parameters;

    public ParameterConsumer(List<? extends ParameterData<?>> parameters) {
        Preconditions.checkNotNull(parameters, (Object)"parameters");
        this.parameters = ImmutableList.copyOf(parameters);
    }

    public Object[] parseArguments(CommandContext context) throws CommandException, InvocationTargetException, ConsumeException, UnconsumedParameterException {
        return this.parseArguments(context, false, (Set<Character>)ImmutableSet.of());
    }

    public Object[] parseArguments(CommandContext context, boolean ignoreUnusedFlags, Set<Character> unusedFlags) throws CommandException, InvocationTargetException, ConsumeException, UnconsumedParameterException {
        ContextArgumentStack arguments = new ContextArgumentStack(context);
        Object[] args = new Object[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterData parameter = (ParameterData)this.parameters.get(i);
            try {
                if (this.mayConsumeArguments(i, arguments)) {
                    ArgumentStack usedArguments = ParameterConsumer.getScopedContext(parameter, arguments);
                    try {
                        args[i] = parameter.getBinding().bind(parameter, usedArguments, false);
                    }
                    catch (MissingParameterException e) {
                        if (!parameter.isOptional()) {
                            throw e;
                        }
                        args[i] = this.getDefaultValue(i, arguments);
                    }
                    continue;
                }
                args[i] = this.getDefaultValue(i, arguments);
                continue;
            }
            catch (ParameterException e) {
                throw new ConsumeException((Parameter)parameter, (Throwable)e);
            }
        }
        this.checkUnconsumed(arguments, ignoreUnusedFlags, unusedFlags);
        return args;
    }

    private static ArgumentStack getScopedContext(Parameter parameter, ArgumentStack existing) {
        if (parameter.getFlag() != null) {
            CommandContext context = existing.getContext();
            if (parameter.isValueFlag()) {
                return new StringArgumentStack(context, context.getFlag(parameter.getFlag().charValue()), false);
            }
            String v = context.hasFlag(parameter.getFlag().charValue()) ? "true" : "false";
            return new StringArgumentStack(context, v, true);
        }
        return existing;
    }

    private boolean mayConsumeArguments(int i, ContextArgumentStack scoped) {
        CommandContext context = scoped.getContext();
        ParameterData parameter = (ParameterData)this.parameters.get(i);
        if (parameter.isOptional()) {
            if (parameter.getFlag() != null) {
                return !parameter.isValueFlag() || context.hasFlag(parameter.getFlag().charValue());
            }
            int numberFree = context.argsLength() - scoped.position();
            for (int j = i; j < this.parameters.size(); ++j) {
                if (!((ParameterData)this.parameters.get(j)).isNonFlagConsumer() || ((ParameterData)this.parameters.get(j)).isOptional()) continue;
                numberFree -= ((ParameterData)this.parameters.get(j)).getConsumedCount();
            }
            if (numberFree < 1) {
                return false;
            }
        }
        return true;
    }

    private Object getDefaultValue(int i, ContextArgumentStack scoped) throws ParameterException, CommandException, InvocationTargetException {
        CommandContext context = scoped.getContext();
        ParameterData parameter = (ParameterData)this.parameters.get(i);
        Object[] defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            try {
                return parameter.getBinding().bind(parameter, new StringArgumentStack(context, (String[])defaultValue, false), false);
            }
            catch (MissingParameterException ignored) {
                throw new ParametricException("The default value '" + Arrays.toString(defaultValue) + "' of the parameter using the binding " + parameter.getBinding().getClass() + " is invalid");
            }
        }
        return null;
    }

    private void checkUnconsumed(ContextArgumentStack scoped, boolean ignoreUnusedFlags, Set<Character> unusedFlags) throws UnconsumedParameterException {
        CommandContext context = scoped.getContext();
        String unconsumedFlags = this.getUnusedFlags(context, ignoreUnusedFlags, unusedFlags);
        String unconsumed = scoped.getUnconsumed();
        if (unconsumed != null) {
            throw new UnconsumedParameterException(unconsumed + " " + unconsumedFlags);
        }
        if (unconsumedFlags != null) {
            throw new UnconsumedParameterException(unconsumedFlags);
        }
    }

    private String getUnusedFlags(CommandContext context, boolean ignoreUnusedFlags, Set<Character> unusedFlags) {
        if (!ignoreUnusedFlags) {
            HashSet<Character> unconsumedFlags = null;
            for (char flag : context.getFlags()) {
                boolean found = false;
                if (unusedFlags.contains(Character.valueOf(flag))) break;
                for (ParameterData parameter : this.parameters) {
                    Character paramFlag = parameter.getFlag();
                    if (paramFlag == null || flag != paramFlag.charValue()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (unconsumedFlags == null) {
                    unconsumedFlags = new HashSet<Character>();
                }
                unconsumedFlags.add(Character.valueOf(flag));
            }
            if (unconsumedFlags != null) {
                StringBuilder builder = new StringBuilder();
                for (Character flag : unconsumedFlags) {
                    builder.append("-").append(flag).append(" ");
                }
                return builder.toString().trim();
            }
        }
        return null;
    }
}

