/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Chars;
import com.sk89q.intake.Command;
import com.sk89q.intake.Parameter;
import com.sk89q.intake.Require;
import com.sk89q.intake.SettableDescription;
import com.sk89q.intake.context.CommandLocals;
import com.sk89q.intake.parametric.AbstractParametricCommand;
import com.sk89q.intake.parametric.ParameterBinder;
import com.sk89q.intake.parametric.ParameterData;
import com.sk89q.intake.parametric.ParametricBuilder;
import com.sk89q.intake.parametric.ParametricException;
import com.sk89q.intake.parametric.handler.InvokeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

class ParametricCallable
extends AbstractParametricCommand {
    private final Object object;
    private final Method method;
    private final SettableDescription description;
    private final Require permissionAnnotation;

    ParametricCallable(ParametricBuilder builder, Object object, Method method, Command definition) throws ParametricException {
        super(builder);
        Preconditions.checkNotNull((Object)builder, (Object)"builder");
        Preconditions.checkNotNull((Object)object, (Object)"object");
        Preconditions.checkNotNull((Object)method, (Object)"method");
        Preconditions.checkNotNull((Object)definition, (Object)"definition");
        this.object = object;
        this.method = method;
        ImmutableSet commandAnnotations = ImmutableSet.copyOf((Object[])method.getAnnotations());
        Annotation[][] annotations = method.getParameterAnnotations();
        Type[] types = method.getGenericParameterTypes();
        ParameterBinder<Method> binder = new ParameterBinder<Method>(builder);
        for (int i = 0; i < types.length; ++i) {
            binder.addParameter(types[i], annotations[i], method);
        }
        this.setParameters((List<? extends ParameterData<?>>)binder.getParameters());
        this.setValueFlags((Set<Character>)binder.getValueFlags());
        this.setIgnoreUnusedFlags(definition.anyFlags());
        this.setUnusedFlags(Sets.newHashSet((Iterable)Chars.asList((char[])definition.flags().toCharArray())));
        this.description = new SettableDescription();
        Require permHint = method.getAnnotation(Require.class);
        if (permHint != null) {
            this.description.setPermissions(Arrays.asList(permHint.value()));
        }
        this.description.setParameters((List<Parameter>)binder.getUserProvidedParameters());
        this.description.setDescription(!definition.desc().isEmpty() ? definition.desc() : null);
        this.description.setHelp(!definition.help().isEmpty() ? definition.help() : null);
        this.description.overrideUsage(!definition.usage().isEmpty() ? definition.usage() : null);
        for (InvokeListener listener : builder.getInvokeListeners()) {
            listener.updateDescription((Set<Annotation>)commandAnnotations, (List<? extends ParameterData<?>>)binder.getParameters(), this.description);
        }
        this.permissionAnnotation = method.getAnnotation(Require.class);
        this.setPermissions(Arrays.asList(this.permissionAnnotation.value()));
        this.setAnnotations((Set<Annotation>)commandAnnotations);
    }

    @Override
    protected void call(Object[] args) throws InvocationTargetException, IllegalAccessException {
        this.method.invoke(this.object, args);
    }

    @Override
    public SettableDescription getDescription() {
        return this.description;
    }

    @Override
    public boolean testPermission(CommandLocals locals) {
        return this.permissionAnnotation == null || super.testPermission(locals);
    }
}

