/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric.handler;

import com.sk89q.intake.Command;
import com.sk89q.intake.CommandException;
import com.sk89q.intake.SettableDescription;
import com.sk89q.intake.context.CommandContext;
import com.sk89q.intake.parametric.MissingParameterException;
import com.sk89q.intake.parametric.ParameterData;
import com.sk89q.intake.parametric.ParameterException;
import com.sk89q.intake.parametric.UnconsumedParameterException;
import com.sk89q.intake.parametric.binding.BindingBehavior;
import com.sk89q.intake.parametric.handler.AbstractInvokeListener;
import com.sk89q.intake.parametric.handler.InvokeHandler;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;

public class LegacyCommandsHandler
extends AbstractInvokeListener
implements InvokeHandler {
    @Override
    public InvokeHandler createInvokeHandler() {
        return this;
    }

    @Override
    public boolean preProcess(Set<Annotation> annotations, List<? extends ParameterData<?>> parameters, CommandContext context) throws CommandException, ParameterException {
        return true;
    }

    @Override
    public boolean preInvoke(Set<Annotation> annotations, List<? extends ParameterData<?>> parameters, Object[] args, CommandContext context) throws ParameterException, UnconsumedParameterException {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Command)) continue;
            Command command = (Command)annotation;
            if (context.argsLength() < command.min()) {
                throw new MissingParameterException();
            }
            if (command.max() == -1 || context.argsLength() <= command.max()) continue;
            throw new UnconsumedParameterException(context.getRemainingString(command.max()));
        }
        return true;
    }

    @Override
    public void postInvoke(Set<Annotation> annotations, List<? extends ParameterData<?>> parameters, Object[] args, CommandContext context) {
    }

    @Override
    public void updateDescription(Set<Annotation> annotations, List<? extends ParameterData<?>> parameters, SettableDescription description) {
        for (Annotation annotation : annotations) {
            Command command;
            if (!(annotation instanceof Command) || !(command = (Command)annotation).usage().isEmpty() || command.min() <= 0 && command.max() <= 0) continue;
            boolean hasUserParameters = false;
            for (ParameterData<?> parameter : parameters) {
                if (parameter.getBinding().getBehavior(parameter) == BindingBehavior.PROVIDES) continue;
                hasUserParameters = true;
                break;
            }
            if (hasUserParameters) continue;
            description.overrideUsage("(unknown usage information)");
        }
    }
}

