/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.intake.Description;
import com.sk89q.intake.Parameter;
import java.util.List;
import javax.annotation.Nullable;

public final class ImmutableDescription
implements Description {
    private final List<Parameter> parameters;
    private final List<String> permissions;
    private final String shortDescription;
    private final String help;
    @Nullable
    private final String usageOverride;

    private ImmutableDescription(List<Parameter> parameters, List<String> permissions, String shortDescription, String help, @Nullable String usageOverride) {
        this.parameters = ImmutableList.copyOf(parameters);
        this.permissions = ImmutableList.copyOf(permissions);
        this.shortDescription = shortDescription;
        this.help = help;
        this.usageOverride = usageOverride;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    @Nullable
    public String getHelp() {
        return this.help;
    }

    @Override
    public List<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public String getUsage() {
        if (this.usageOverride != null) {
            return this.usageOverride;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Parameter parameter : this.parameters) {
            if (!first) {
                builder.append(" ");
            }
            builder.append(parameter);
            first = false;
        }
        return builder.toString();
    }

    public String toString() {
        return this.getUsage();
    }

    public static class Builder {
        private List<Parameter> parameters = ImmutableList.of();
        private List<String> permissions = ImmutableList.of();
        @Nullable
        private String shortDescription;
        @Nullable
        private String help;
        @Nullable
        private String usageOverride;

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public Builder setParameters(List<Parameter> parameters) {
            Preconditions.checkNotNull(parameters, (Object)"parameters");
            this.parameters = parameters;
            return this;
        }

        public List<String> getPermissions() {
            return this.permissions;
        }

        public Builder setPermissions(List<String> permissions) {
            Preconditions.checkNotNull(permissions, (Object)"permissions");
            this.permissions = permissions;
            return this;
        }

        @Nullable
        public String getShortDescription() {
            return this.shortDescription;
        }

        public Builder setShortDescription(@Nullable String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        @Nullable
        public String getHelp() {
            return this.help;
        }

        public Builder setHelp(@Nullable String help) {
            this.help = help;
            return this;
        }

        @Nullable
        public String getUsageOverride() {
            return this.usageOverride;
        }

        public Builder setUsageOverride(@Nullable String usageOverride) {
            this.usageOverride = usageOverride;
            return this;
        }

        public ImmutableDescription build() {
            return new ImmutableDescription(this.parameters, this.permissions, this.shortDescription, this.help, this.usageOverride);
        }
    }
}

