/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.intake.OptionType;
import com.sk89q.intake.Parameter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class ImmutableParameter
implements Parameter {
    private final String name;
    @Nullable
    private final OptionType optionType;
    private final List<String> defaultValue;

    private ImmutableParameter(String name, OptionType optionType, List<String> defaultValue) {
        this.name = name;
        this.optionType = optionType;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OptionType getOptionType() {
        return this.optionType;
    }

    @Override
    public List<String> getDefaultValue() {
        return this.defaultValue;
    }

    public static class Builder {
        private String name;
        private OptionType optionType;
        private List<String> defaultValue = Collections.emptyList();

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            this.name = name;
            return this;
        }

        public OptionType getOptionType() {
            return this.optionType;
        }

        public Builder setOptionType(OptionType optionType) {
            Preconditions.checkNotNull((Object)optionType, (Object)"optionType");
            this.optionType = optionType;
            return this;
        }

        public List<String> getDefaultValue() {
            return this.defaultValue;
        }

        public Builder setDefaultValue(List<String> defaultValue) {
            Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
            this.defaultValue = ImmutableList.copyOf(defaultValue);
            return this;
        }

        public ImmutableParameter build() {
            Preconditions.checkNotNull((Object)this.name, (Object)"name");
            Preconditions.checkNotNull((Object)this.optionType, (Object)"optionType");
            return new ImmutableParameter(this.name, this.optionType, this.defaultValue);
        }
    }
}

