/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.intake.argument.Arguments;
import com.sk89q.intake.argument.CommandArgs;
import java.util.List;
import javax.annotation.Nullable;

public abstract class OptionType {
    private static final RequiredPositional REQUIRED_PARAMETER = new RequiredPositional();
    private static final OptionalPositional OPTIONAL_PARAMETER = new OptionalPositional();

    private OptionType() {
    }

    @Nullable
    public abstract Character getFlag();

    public abstract boolean isValueFlag();

    public abstract boolean isOptional();

    public abstract CommandArgs transform(CommandArgs var1);

    public static OptionType positional() {
        return REQUIRED_PARAMETER;
    }

    public static OptionType optionalPositional() {
        return OPTIONAL_PARAMETER;
    }

    public static OptionType flag(Character flag) {
        Preconditions.checkNotNull((Object)flag, (Object)"flag");
        return new BooleanFlag(flag);
    }

    public static OptionType valueFlag(Character flag) {
        Preconditions.checkNotNull((Object)flag, (Object)"flag");
        return new ValueFlag(flag);
    }

    private static final class ValueFlag
    extends OptionType {
        private final Character flag;

        private ValueFlag(Character flag) {
            this.flag = flag;
        }

        @Override
        @Nullable
        public Character getFlag() {
            return this.flag;
        }

        @Override
        public boolean isValueFlag() {
            return true;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public CommandArgs transform(CommandArgs arguments) {
            String value = arguments.getFlags().get(this.flag);
            if (value == null) {
                value = "";
            }
            return Arguments.copyOf((List<String>)ImmutableList.of((Object)value), arguments.getFlags(), arguments.getNamespace());
        }
    }

    private static final class BooleanFlag
    extends OptionType {
        private final Character flag;

        private BooleanFlag(Character flag) {
            this.flag = flag;
        }

        @Override
        @Nullable
        public Character getFlag() {
            return this.flag;
        }

        @Override
        public boolean isValueFlag() {
            return false;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public CommandArgs transform(CommandArgs arguments) {
            String v = arguments.getFlags().containsKey(this.flag) ? "true" : "false";
            return Arguments.copyOf((List<String>)ImmutableList.of((Object)v), arguments.getFlags(), arguments.getNamespace());
        }
    }

    private static final class OptionalPositional
    extends OptionType {
        private OptionalPositional() {
        }

        @Override
        @Nullable
        public Character getFlag() {
            return null;
        }

        @Override
        public boolean isValueFlag() {
            return false;
        }

        @Override
        public boolean isOptional() {
            return true;
        }

        @Override
        public CommandArgs transform(CommandArgs arguments) {
            return arguments;
        }
    }

    private static final class RequiredPositional
    extends OptionType {
        private RequiredPositional() {
        }

        @Override
        @Nullable
        public Character getFlag() {
            return null;
        }

        @Override
        public boolean isValueFlag() {
            return false;
        }

        @Override
        public boolean isOptional() {
            return false;
        }

        @Override
        public CommandArgs transform(CommandArgs arguments) {
            return arguments;
        }
    }
}

