/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.argument;

import com.sk89q.intake.argument.ArgumentParseException;
import com.sk89q.intake.argument.CommandArgs;
import com.sk89q.intake.argument.MissingArgumentException;

abstract class AbstractCommandArgs
implements CommandArgs {
    AbstractCommandArgs() {
    }

    @Override
    public int nextInt() throws MissingArgumentException, ArgumentParseException {
        String next = this.next();
        try {
            return Integer.parseInt(next);
        }
        catch (NumberFormatException ignored) {
            throw new ArgumentParseException("Expected a number, got '" + next + "'");
        }
    }

    @Override
    public short nextShort() throws MissingArgumentException, ArgumentParseException {
        String next = this.next();
        try {
            return Short.parseShort(next);
        }
        catch (NumberFormatException ignored) {
            throw new ArgumentParseException("Expected a number, got '" + next + "'");
        }
    }

    @Override
    public byte nextByte() throws MissingArgumentException, ArgumentParseException {
        String next = this.next();
        try {
            return Byte.parseByte(next);
        }
        catch (NumberFormatException ignored) {
            throw new ArgumentParseException("Expected a number, got '" + next + "'");
        }
    }

    @Override
    public double nextDouble() throws MissingArgumentException, ArgumentParseException {
        String next = this.next();
        try {
            return Double.parseDouble(next);
        }
        catch (NumberFormatException ignored) {
            throw new ArgumentParseException("Expected a number, got '" + next + "'");
        }
    }

    @Override
    public float nextFloat() throws MissingArgumentException, ArgumentParseException {
        String next = this.next();
        try {
            return Float.parseFloat(next);
        }
        catch (NumberFormatException ignored) {
            throw new ArgumentParseException("Expected a number, got '" + next + "'");
        }
    }

    @Override
    public boolean nextBoolean() throws MissingArgumentException, ArgumentParseException {
        String next = this.next();
        if (next.equalsIgnoreCase("yes") || next.equalsIgnoreCase("true") || next.equalsIgnoreCase("y") || next.equalsIgnoreCase("1")) {
            return true;
        }
        if (next.equalsIgnoreCase("no") || next.equalsIgnoreCase("false") || next.equalsIgnoreCase("n") || next.equalsIgnoreCase("0")) {
            return false;
        }
        throw new ArgumentParseException("Expected a boolean (yes/no), got '" + next + "'");
    }
}

