/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.argument;

import com.google.common.base.Preconditions;
import com.sk89q.intake.argument.AbstractCommandArgs;
import com.sk89q.intake.argument.CommandContext;
import com.sk89q.intake.argument.MissingArgumentException;
import com.sk89q.intake.argument.Namespace;
import java.util.Map;

class ContextArgs
extends AbstractCommandArgs {
    private final CommandContext context;
    private int position = 0;

    ContextArgs(CommandContext context) {
        Preconditions.checkNotNull((Object)context, (Object)"context");
        this.context = context;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.context.argsLength();
    }

    @Override
    public String next() throws MissingArgumentException {
        try {
            return this.context.getString(this.position++);
        }
        catch (IndexOutOfBoundsException ignored) {
            throw new MissingArgumentException();
        }
    }

    @Override
    public String peek() throws MissingArgumentException {
        try {
            return this.context.getString(this.position);
        }
        catch (IndexOutOfBoundsException ignored) {
            throw new MissingArgumentException();
        }
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public int size() {
        return this.context.argsLength();
    }

    @Override
    public void markConsumed() {
        this.position = this.context.argsLength();
    }

    @Override
    public Map<Character, String> getFlags() {
        return this.context.getFlagsMap();
    }

    @Override
    public Namespace getNamespace() {
        return this.context.getNamespace();
    }
}

