/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.argument;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.intake.argument.AbstractCommandArgs;
import com.sk89q.intake.argument.MissingArgumentException;
import com.sk89q.intake.argument.Namespace;
import java.util.List;
import java.util.Map;

class StringListArgs
extends AbstractCommandArgs {
    private final List<String> arguments;
    private final Map<Character, String> flags;
    private final Namespace namespace;
    private int position = 0;

    StringListArgs(List<String> arguments, Map<Character, String> flags, Namespace namespace) {
        Preconditions.checkNotNull(arguments, (Object)"arguments");
        Preconditions.checkNotNull(flags, (Object)"flags");
        Preconditions.checkNotNull((Object)namespace, (Object)"namespace");
        this.arguments = ImmutableList.copyOf(arguments);
        this.flags = flags;
        this.namespace = namespace;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.arguments.size();
    }

    @Override
    public String next() throws MissingArgumentException {
        try {
            return this.arguments.get(this.position++);
        }
        catch (IndexOutOfBoundsException ignored) {
            throw new MissingArgumentException();
        }
    }

    @Override
    public String peek() throws MissingArgumentException {
        try {
            return this.arguments.get(this.position);
        }
        catch (IndexOutOfBoundsException ignored) {
            throw new MissingArgumentException();
        }
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public int size() {
        return this.arguments.size();
    }

    @Override
    public void markConsumed() {
        this.position = this.arguments.size();
    }

    @Override
    public Map<Character, String> getFlags() {
        return this.flags;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }
}

