/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.dispatcher;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sk89q.intake.CommandCallable;
import com.sk89q.intake.CommandException;
import com.sk89q.intake.CommandMapping;
import com.sk89q.intake.Description;
import com.sk89q.intake.ImmutableCommandMapping;
import com.sk89q.intake.ImmutableDescription;
import com.sk89q.intake.ImmutableParameter;
import com.sk89q.intake.InvalidUsageException;
import com.sk89q.intake.InvocationCommandException;
import com.sk89q.intake.OptionType;
import com.sk89q.intake.argument.CommandContext;
import com.sk89q.intake.argument.Namespace;
import com.sk89q.intake.dispatcher.Dispatcher;
import com.sk89q.intake.util.auth.AuthorizationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleDispatcher
implements Dispatcher {
    private final Map<String, CommandMapping> commands = new HashMap<String, CommandMapping>();
    private final Description description;

    public SimpleDispatcher() {
        ArrayList parameters = Lists.newArrayList();
        parameters.add(new ImmutableParameter.Builder().setName("subcommand").setOptionType(OptionType.positional()).build());
        parameters.add(new ImmutableParameter.Builder().setName("...").setOptionType(OptionType.optionalPositional()).build());
        this.description = new ImmutableDescription.Builder().setParameters(parameters).build();
    }

    @Override
    public void registerCommand(CommandCallable callable, String ... alias) {
        String lower;
        ImmutableCommandMapping mapping = new ImmutableCommandMapping(callable, alias);
        for (String a : alias) {
            lower = a.toLowerCase();
            if (!this.commands.containsKey(lower)) continue;
            throw new IllegalArgumentException("Replacing commands is currently undefined behavior");
        }
        for (String a : alias) {
            lower = a.toLowerCase();
            this.commands.put(lower, mapping);
        }
    }

    @Override
    public Set<CommandMapping> getCommands() {
        return Collections.unmodifiableSet(new HashSet<CommandMapping>(this.commands.values()));
    }

    public Set<String> getAliases() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }

    public Set<String> getPrimaryAliases() {
        HashSet<String> aliases = new HashSet<String>();
        for (CommandMapping mapping : this.getCommands()) {
            aliases.add(mapping.getPrimaryAlias());
        }
        return Collections.unmodifiableSet(aliases);
    }

    @Override
    public boolean contains(String alias) {
        return this.commands.containsKey(alias.toLowerCase());
    }

    @Override
    public CommandMapping get(String alias) {
        return this.commands.get(alias.toLowerCase());
    }

    @Override
    public boolean call(String arguments, Namespace namespace, List<String> parentCommands) throws CommandException, InvocationCommandException, AuthorizationException {
        if (!this.testPermission(namespace)) {
            throw new AuthorizationException();
        }
        String[] split = CommandContext.split(arguments);
        Collection aliases = this.getPrimaryAliases();
        if (aliases.isEmpty()) {
            throw new InvalidUsageException("This command has no sub-commands.", this);
        }
        if (split.length > 0) {
            String subCommand = split[0];
            String subArguments = Joiner.on((String)" ").join((Object[])Arrays.copyOfRange(split, 1, split.length));
            ImmutableList subParents = ImmutableList.builder().addAll(parentCommands).add((Object)subCommand).build();
            CommandMapping mapping = this.get(subCommand);
            if (mapping != null) {
                try {
                    mapping.getCallable().call(subArguments, namespace, (List<String>)subParents);
                }
                catch (AuthorizationException e) {
                    throw e;
                }
                catch (CommandException e) {
                    e.prependStack(subCommand);
                    throw e;
                }
                catch (Throwable t) {
                    throw new InvocationCommandException(t);
                }
                return true;
            }
        }
        throw new InvalidUsageException("Please choose a sub-command.", this, true);
    }

    @Override
    public List<String> getSuggestions(String arguments, Namespace locals) throws CommandException {
        String[] split = CommandContext.split(arguments);
        if (split.length <= 1) {
            String prefix = split.length > 0 ? split[0] : "";
            ArrayList<String> suggestions = new ArrayList<String>();
            block0: for (CommandMapping mapping : this.getCommands()) {
                if (!mapping.getCallable().testPermission(locals)) continue;
                for (String alias : mapping.getAllAliases()) {
                    if (!prefix.isEmpty() && !alias.startsWith(arguments)) continue;
                    suggestions.add(mapping.getPrimaryAlias());
                    continue block0;
                }
            }
            return suggestions;
        }
        String subCommand = split[0];
        CommandMapping mapping = this.get(subCommand);
        String passedArguments = Joiner.on((String)" ").join((Object[])Arrays.copyOfRange(split, 1, split.length));
        if (mapping != null) {
            return mapping.getCallable().getSuggestions(passedArguments, locals);
        }
        return Collections.emptyList();
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public boolean testPermission(Namespace locals) {
        for (CommandMapping mapping : this.getCommands()) {
            if (!mapping.getCallable().testPermission(locals)) continue;
            return true;
        }
        return false;
    }
}

