/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.internal.parametric;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.sk89q.intake.parametric.Binding;
import com.sk89q.intake.parametric.Key;
import com.sk89q.intake.parametric.Provider;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

class BindingList {
    private final Multimap<Type, BindingEntry<?>> providers = Multimaps.newMultimap((Map)Maps.newHashMap(), (Supplier)new CollectionSupplier());

    BindingList() {
    }

    public <T> void addBinding(Key<T> key, Provider<T> provider) {
        Preconditions.checkNotNull(key, (Object)"key");
        Preconditions.checkNotNull(provider, (Object)"provider");
        this.providers.put((Object)key.getType(), new BindingEntry(key, provider));
    }

    @Nullable
    public <T> Binding<T> getBinding(Key<T> key) {
        Preconditions.checkNotNull(key, (Object)"key");
        for (BindingEntry binding : this.providers.get((Object)key.getType())) {
            if (!binding.getKey().matches(key)) continue;
            return binding;
        }
        return null;
    }

    private static final class BindingEntry<T>
    implements Binding<T>,
    Comparable<BindingEntry<?>> {
        private final Key<T> key;
        private final Provider<T> provider;

        private BindingEntry(Key<T> key, Provider<T> provider) {
            this.key = key;
            this.provider = provider;
        }

        @Override
        public Key<T> getKey() {
            return this.key;
        }

        @Override
        public Provider<T> getProvider() {
            return this.provider;
        }

        @Override
        public int compareTo(BindingEntry<?> o) {
            return this.key.compareTo(o.key);
        }

        public String toString() {
            return "BindingEntry{key=" + this.key + ", provider=" + this.provider + '}';
        }
    }

    private static class CollectionSupplier
    implements Supplier<Collection<BindingEntry<?>>> {
        private CollectionSupplier() {
        }

        public Collection<BindingEntry<?>> get() {
            return Sets.newTreeSet();
        }
    }
}

