/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.internal.parametric;

import com.google.common.base.Preconditions;
import com.sk89q.intake.internal.parametric.BindingList;
import com.sk89q.intake.internal.parametric.ConstantProvider;
import com.sk89q.intake.parametric.Key;
import com.sk89q.intake.parametric.Provider;
import com.sk89q.intake.parametric.binder.BindingBuilder;
import java.lang.annotation.Annotation;
import javax.annotation.Nullable;

class InternalBinderBuilder<T>
implements BindingBuilder<T> {
    private final BindingList bindings;
    private Key<T> key;

    public InternalBinderBuilder(BindingList bindings, Key<T> key) {
        Preconditions.checkNotNull((Object)bindings, (Object)"bindings");
        Preconditions.checkNotNull(key, (Object)"key");
        this.bindings = bindings;
        this.key = key;
    }

    @Override
    public BindingBuilder<T> annotatedWith(@Nullable Class<? extends Annotation> annotation) {
        this.key = this.key.setClassifier(annotation);
        return this;
    }

    @Override
    public void toProvider(Provider<T> provider) {
        this.bindings.addBinding(this.key, provider);
    }

    @Override
    public void toInstance(T instance) {
        this.toProvider(new ConstantProvider<T>(instance));
    }
}

