/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.internal.parametric;

import com.google.common.base.Preconditions;
import com.sk89q.intake.argument.ArgumentException;
import com.sk89q.intake.argument.CommandArgs;
import com.sk89q.intake.internal.parametric.BindingList;
import com.sk89q.intake.internal.parametric.InternalBinder;
import com.sk89q.intake.parametric.Binding;
import com.sk89q.intake.parametric.Injector;
import com.sk89q.intake.parametric.Key;
import com.sk89q.intake.parametric.Module;
import com.sk89q.intake.parametric.Provider;
import com.sk89q.intake.parametric.ProvisionException;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Nullable;

public class InternalInjector
implements Injector {
    private final BindingList bindings = new BindingList();

    @Override
    public void install(Module module) {
        Preconditions.checkNotNull((Object)module, (Object)"module");
        module.configure(new InternalBinder(this.bindings));
    }

    @Override
    @Nullable
    public <T> Binding<T> getBinding(Key<T> key) {
        return this.bindings.getBinding(key);
    }

    @Override
    @Nullable
    public <T> Binding<T> getBinding(Class<T> type) {
        return this.getBinding(Key.get(type));
    }

    @Override
    @Nullable
    public <T> Provider<T> getProvider(Key<T> key) {
        Binding<T> binding = this.getBinding(key);
        return binding != null ? binding.getProvider() : null;
    }

    @Override
    @Nullable
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.getProvider(Key.get(type));
    }

    @Override
    public <T> T getInstance(Key<T> key, CommandArgs arguments, List<? extends Annotation> modifiers) throws ArgumentException, ProvisionException {
        Provider<T> provider = this.getProvider(key);
        if (provider != null) {
            return provider.get(arguments, modifiers);
        }
        throw new ProvisionException("No binding was found for " + key);
    }

    @Override
    public <T> T getInstance(Class<T> type, CommandArgs arguments, List<? extends Annotation> modifiers) throws ArgumentException, ProvisionException {
        return this.getInstance(Key.get(type), arguments, modifiers);
    }
}

