/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.sk89q.intake.CommandCallable;
import com.sk89q.intake.CommandException;
import com.sk89q.intake.InvalidUsageException;
import com.sk89q.intake.InvocationCommandException;
import com.sk89q.intake.argument.ArgumentException;
import com.sk89q.intake.argument.ArgumentParseException;
import com.sk89q.intake.argument.Arguments;
import com.sk89q.intake.argument.CommandArgs;
import com.sk89q.intake.argument.CommandContext;
import com.sk89q.intake.argument.MissingArgumentException;
import com.sk89q.intake.argument.Namespace;
import com.sk89q.intake.argument.UnusedArgumentException;
import com.sk89q.intake.parametric.ArgumentParser;
import com.sk89q.intake.parametric.ParametricBuilder;
import com.sk89q.intake.parametric.ProvisionException;
import com.sk89q.intake.parametric.handler.ExceptionConverter;
import com.sk89q.intake.parametric.handler.InvokeHandler;
import com.sk89q.intake.parametric.handler.InvokeListener;
import com.sk89q.intake.util.auth.AuthorizationException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public abstract class AbstractParametricCallable
implements CommandCallable {
    private final ParametricBuilder builder;
    private final ArgumentParser parser;
    private List<? extends Annotation> commandAnnotations = Collections.emptyList();
    private boolean ignoreUnusedFlags = false;
    private Set<Character> unusedFlags = Collections.emptySet();

    protected AbstractParametricCallable(ParametricBuilder builder, ArgumentParser parser) {
        Preconditions.checkNotNull((Object)builder, (Object)"builder");
        Preconditions.checkNotNull((Object)parser, (Object)"parser");
        this.builder = builder;
        this.parser = parser;
    }

    protected ParametricBuilder getBuilder() {
        return this.builder;
    }

    protected ArgumentParser getParser() {
        return this.parser;
    }

    protected List<? extends Annotation> getCommandAnnotations() {
        return this.commandAnnotations;
    }

    protected void setCommandAnnotations(List<? extends Annotation> commandAnnotations) {
        this.commandAnnotations = ImmutableList.copyOf(commandAnnotations);
    }

    protected boolean isIgnoreUnusedFlags() {
        return this.ignoreUnusedFlags;
    }

    protected void setIgnoreUnusedFlags(boolean ignoreUnusedFlags) {
        this.ignoreUnusedFlags = ignoreUnusedFlags;
    }

    protected Set<Character> getUnusedFlags() {
        return this.unusedFlags;
    }

    protected void setUnusedFlags(Set<Character> unusedFlags) {
        this.unusedFlags = ImmutableSet.copyOf(unusedFlags);
    }

    @Override
    public final boolean call(String stringArguments, Namespace namespace, List<String> parentCommands) throws CommandException, InvocationCommandException, AuthorizationException {
        if (!this.testPermission(namespace)) {
            throw new AuthorizationException();
        }
        String calledCommand = !parentCommands.isEmpty() ? parentCommands.get(parentCommands.size() - 1) : "_";
        String[] split = CommandContext.split(calledCommand + " " + stringArguments);
        CommandContext context = new CommandContext(split, this.parser.getValueFlags(), false, namespace);
        CommandArgs commandArgs = Arguments.viewOf(context);
        ArrayList<InvokeHandler> handlers = new ArrayList<InvokeHandler>();
        if (context.hasFlag('?')) {
            throw new InvalidUsageException(null, this, true);
        }
        for (InvokeListener invokeListener : this.builder.getInvokeListeners()) {
            InvokeHandler invokeHandler = invokeListener.createInvokeHandler();
            handlers.add(invokeHandler);
        }
        try {
            boolean invoke = true;
            for (InvokeHandler invokeHandler : handlers) {
                if (invokeHandler.preProcess(this.commandAnnotations, this.parser, commandArgs)) continue;
                invoke = false;
            }
            if (!invoke) {
                return true;
            }
            final Object[] objectArray = this.parser.parseArguments(commandArgs, this.ignoreUnusedFlags, this.unusedFlags);
            for (InvokeHandler handler : handlers) {
                if (handler.preInvoke(this.commandAnnotations, this.parser, objectArray, commandArgs)) continue;
                invoke = false;
            }
            if (!invoke) {
                return true;
            }
            this.builder.getCommandExecutor().submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    AbstractParametricCallable.this.call(objectArray);
                    return null;
                }
            }).get();
            for (InvokeHandler handler : handlers) {
                handler.postInvoke(this.commandAnnotations, this.parser, objectArray, commandArgs);
            }
        }
        catch (MissingArgumentException e) {
            if (e.getParameter() != null) {
                throw new InvalidUsageException("Too few arguments! No value found for parameter '" + e.getParameter().getName() + "'", this);
            }
            throw new InvalidUsageException("Too few arguments!", this);
        }
        catch (UnusedArgumentException e) {
            throw new InvalidUsageException("Too many arguments! Unused arguments: " + e.getUnconsumed(), this);
        }
        catch (ArgumentParseException e) {
            if (e.getParameter() != null) {
                throw new InvalidUsageException("For parameter '" + e.getParameter().getName() + "': " + e.getMessage(), this);
            }
            throw new InvalidUsageException("Error parsing arguments: " + e.getMessage(), this);
        }
        catch (ArgumentException e) {
            throw new InvalidUsageException("Error parsing arguments: " + e.getMessage(), this);
        }
        catch (ProvisionException e) {
            throw new InvocationCommandException("Internal error occurred: " + e.getMessage(), e);
        }
        catch (ExecutionException e) {
            for (ExceptionConverter exceptionConverter : this.builder.getExceptionConverters()) {
                exceptionConverter.convert(e.getCause());
            }
            throw new InvocationCommandException(e.getMessage(), e.getCause());
        }
        catch (InterruptedException e) {
            throw new InvocationCommandException("Execution of the command was interrupted", e.getCause());
        }
        return true;
    }

    protected abstract void call(Object[] var1) throws CommandException, InvocationCommandException;

    @Override
    public List<String> getSuggestions(String arguments, Namespace locals) throws CommandException {
        return this.builder.getDefaultCompleter().getSuggestions(arguments, locals);
    }
}

