/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sk89q.intake.ImmutableParameter;
import com.sk89q.intake.OptionType;
import com.sk89q.intake.Parameter;
import com.sk89q.intake.argument.ArgumentException;
import com.sk89q.intake.argument.ArgumentParseException;
import com.sk89q.intake.argument.Arguments;
import com.sk89q.intake.argument.CommandArgs;
import com.sk89q.intake.argument.MissingArgumentException;
import com.sk89q.intake.argument.UnusedArgumentException;
import com.sk89q.intake.parametric.Binding;
import com.sk89q.intake.parametric.IllegalParameterException;
import com.sk89q.intake.parametric.Injector;
import com.sk89q.intake.parametric.Key;
import com.sk89q.intake.parametric.Provider;
import com.sk89q.intake.parametric.ProvisionException;
import com.sk89q.intake.parametric.annotation.Classifier;
import com.sk89q.intake.parametric.annotation.Optional;
import com.sk89q.intake.parametric.annotation.Switch;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ArgumentParser {
    private final List<ParameterEntry> parameters;
    private final List<Parameter> userParams;
    private final Set<Character> valueFlags;

    private ArgumentParser(List<ParameterEntry> parameters, List<Parameter> userParams, Set<Character> valueFlags) {
        this.parameters = ImmutableList.copyOf(parameters);
        this.userParams = ImmutableList.copyOf(userParams);
        this.valueFlags = ImmutableSet.copyOf(valueFlags);
    }

    public List<Parameter> getUserParameters() {
        return this.userParams;
    }

    public Set<Character> getValueFlags() {
        return this.valueFlags;
    }

    public Object[] parseArguments(CommandArgs args) throws ArgumentException, ProvisionException {
        return this.parseArguments(args, false, Collections.<Character>emptySet());
    }

    public Object[] parseArguments(CommandArgs args, boolean ignoreUnusedFlags, Set<Character> unusedFlags) throws ArgumentException, ProvisionException {
        Object[] parsedObjects = new Object[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParameterEntry entry = this.parameters.get(i);
            OptionType optionType = entry.getParameter().getOptionType();
            CommandArgs argsForParameter = optionType.transform(args);
            try {
                parsedObjects[i] = entry.getBinding().getProvider().get(argsForParameter, entry.getModifiers());
                continue;
            }
            catch (ArgumentParseException e) {
                throw new ArgumentParseException(e.getMessage(), e, entry.getParameter());
            }
            catch (MissingArgumentException e) {
                if (!optionType.isOptional()) {
                    throw new MissingArgumentException(e, entry.getParameter());
                }
                parsedObjects[i] = this.getDefaultValue(entry, args);
            }
        }
        this.checkUnconsumed(args, ignoreUnusedFlags, unusedFlags);
        return parsedObjects;
    }

    private Object getDefaultValue(ParameterEntry entry, CommandArgs arguments) {
        Provider<?> provider = entry.getBinding().getProvider();
        List<String> defaultValue = entry.getParameter().getDefaultValue();
        if (defaultValue.isEmpty()) {
            return null;
        }
        try {
            return provider.get(Arguments.copyOf(defaultValue, arguments.getFlags(), arguments.getNamespace()), entry.getModifiers());
        }
        catch (ArgumentException e) {
            throw new IllegalParameterException("No value was specified for the '" + entry.getParameter().getName() + "' parameter " + "so the default value '" + Joiner.on((String)" ").join(defaultValue) + "' was used, but this value doesn't work due to an error: " + e.getMessage());
        }
        catch (ProvisionException e) {
            throw new IllegalParameterException("No value was specified for the '" + entry.getParameter().getName() + "' parameter " + "so the default value '" + Joiner.on((String)" ").join(defaultValue) + "' was used, but this value doesn't work due to an error: " + e.getMessage());
        }
    }

    private void checkUnconsumed(CommandArgs arguments, boolean ignoreUnusedFlags, Set<Character> unusedFlags) throws UnusedArgumentException {
        ArrayList unconsumedArguments = Lists.newArrayList();
        if (!ignoreUnusedFlags) {
            HashSet<Character> unconsumedFlags = null;
            for (char flag : arguments.getFlags().keySet()) {
                boolean found = false;
                if (unusedFlags.contains(Character.valueOf(flag))) break;
                for (ParameterEntry parameter : this.parameters) {
                    Character paramFlag = parameter.getParameter().getOptionType().getFlag();
                    if (paramFlag == null || flag != paramFlag.charValue()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (unconsumedFlags == null) {
                    unconsumedFlags = new HashSet<Character>();
                }
                unconsumedFlags.add(Character.valueOf(flag));
            }
            if (unconsumedFlags != null) {
                for (Character flag : unconsumedFlags) {
                    unconsumedArguments.add("-" + flag);
                }
            }
        }
        try {
            while (true) {
                unconsumedArguments.add(arguments.next());
            }
        }
        catch (MissingArgumentException ignored) {
            if (!unconsumedArguments.isEmpty()) {
                throw new UnusedArgumentException(Joiner.on((String)" ").join((Iterable)unconsumedArguments));
            }
            return;
        }
    }

    private static class ParameterEntry {
        private final Parameter parameter;
        private final Key<?> key;
        private final Binding<?> binding;
        private final List<Annotation> modifiers;

        ParameterEntry(Parameter parameter, Key<?> key, Binding<?> binding, List<Annotation> modifiers) {
            this.parameter = parameter;
            this.key = key;
            this.binding = binding;
            this.modifiers = modifiers;
        }

        public Parameter getParameter() {
            return this.parameter;
        }

        public Key<?> getKey() {
            return this.key;
        }

        public Binding<?> getBinding() {
            return this.binding;
        }

        public List<Annotation> getModifiers() {
            return this.modifiers;
        }
    }

    public static class Builder {
        private final Injector injector;
        private final List<ParameterEntry> parameters = Lists.newArrayList();
        private final List<Parameter> userProvidedParameters = Lists.newArrayList();
        private final Set<Character> valueFlags = Sets.newHashSet();
        private boolean seenOptionalParameter = false;

        public Builder(Injector injector) {
            Preconditions.checkNotNull((Object)injector, (Object)"injector");
            this.injector = injector;
        }

        public void addParameter(Type type) throws IllegalParameterException {
            this.addParameter(type, (List<? extends Annotation>)ImmutableList.of());
        }

        public void addParameter(Type type, List<? extends Annotation> annotations) throws IllegalParameterException {
            Preconditions.checkNotNull((Object)type, (Object)"type");
            Preconditions.checkNotNull(annotations, (Object)"annotations");
            int index = this.parameters.size();
            OptionType optionType = null;
            ImmutableList defaultValue = ImmutableList.of();
            Annotation classifier = null;
            ArrayList modifiers = Lists.newArrayList();
            for (Annotation annotation : annotations) {
                if (annotation.annotationType().getAnnotation(Classifier.class) != null) {
                    classifier = annotation;
                    continue;
                }
                modifiers.add(annotation);
                if (annotation instanceof Switch) {
                    if (optionType != null) {
                        throw new IllegalParameterException("Both @Optional and @Switch were found on the same element for parameter #" + index);
                    }
                    optionType = type == Boolean.TYPE ? OptionType.flag(Character.valueOf(((Switch)annotation).value())) : OptionType.valueFlag(Character.valueOf(((Switch)annotation).value()));
                    continue;
                }
                if (!(annotation instanceof Optional)) continue;
                if (optionType != null) {
                    throw new IllegalParameterException("Both @Optional and @Switch were found on the same element for parameter #" + index);
                }
                this.seenOptionalParameter = true;
                optionType = OptionType.optionalPositional();
                Object[] value = ((Optional)annotation).value();
                if (value.length <= 0) continue;
                defaultValue = ImmutableList.copyOf((Object[])value);
            }
            if (optionType == null) {
                optionType = OptionType.positional();
            }
            if (this.seenOptionalParameter && !optionType.isOptional()) {
                throw new IllegalParameterException("An non-optional parameter followed an optional parameter at #" + index);
            }
            ImmutableParameter.Builder builder = new ImmutableParameter.Builder();
            builder.setName(Builder.getFriendlyName(type, classifier, index));
            builder.setOptionType(optionType);
            builder.setDefaultValue((List<String>)defaultValue);
            ImmutableParameter immutableParameter = builder.build();
            Key key = Key.get(type, classifier != null ? classifier.getClass() : null);
            Binding binding = this.injector.getBinding(key);
            if (binding == null) {
                throw new IllegalParameterException("Can't finding a binding for the parameter type '" + type + "'");
            }
            ParameterEntry entry = new ParameterEntry(immutableParameter, key, binding, modifiers);
            if (optionType.isValueFlag()) {
                this.valueFlags.add(optionType.getFlag());
            }
            if (!binding.getProvider().isProvided()) {
                this.userProvidedParameters.add(immutableParameter);
            }
            this.parameters.add(entry);
        }

        public ArgumentParser build() {
            return new ArgumentParser(this.parameters, this.userProvidedParameters, this.valueFlags);
        }

        private static String getFriendlyName(Type type, Annotation classifier, int index) {
            if (classifier != null) {
                return classifier.annotationType().getSimpleName().toLowerCase();
            }
            return type instanceof Class ? ((Class)type).getSimpleName().toLowerCase() : "unknown" + index;
        }
    }
}

