/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public final class Key<T>
implements Comparable<Key<?>> {
    private final Type type;
    @Nullable
    private final Class<? extends Annotation> classifier;

    private Key(Type type, @Nullable Class<? extends Annotation> classifier) {
        this.type = type;
        this.classifier = classifier;
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    public Class<? extends Annotation> getClassifier() {
        return this.classifier;
    }

    public boolean matches(Key<T> key) {
        Preconditions.checkNotNull(key, (Object)"key");
        return this.type.equals(key.getType()) && (this.classifier == null || this.classifier.equals(key.getClassifier()));
    }

    public Key<T> setClassifier(@Nullable Class<? extends Annotation> classifier) {
        return new Key<T>(this.type, classifier);
    }

    @Override
    public int compareTo(Key<?> o) {
        if (this.classifier != null && o.classifier == null) {
            return -1;
        }
        if (this.classifier == null && o.classifier != null) {
            return 1;
        }
        if (this.classifier != null) {
            if (this.type != null && o.type == null) {
                return -1;
            }
            if (this.type == null && o.type != null) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public String toString() {
        return "Key{type=" + this.type + ", classifier=" + this.classifier + '}';
    }

    public static <T> Key<T> get(Class<T> type) {
        return new Key<T>(type, null);
    }

    public static <T> Key<T> get(Class<T> type, @Nullable Class<? extends Annotation> classifier) {
        return new Key<T>(type, classifier);
    }

    public static <T> Key<T> get(Type type) {
        return new Key<T>(type, null);
    }

    public static <T> Key<T> get(Type type, @Nullable Class<? extends Annotation> classifier) {
        return new Key<T>(type, classifier);
    }
}

