/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Chars;
import com.sk89q.intake.Command;
import com.sk89q.intake.Description;
import com.sk89q.intake.ImmutableDescription;
import com.sk89q.intake.InvocationCommandException;
import com.sk89q.intake.Require;
import com.sk89q.intake.argument.Namespace;
import com.sk89q.intake.parametric.AbstractParametricCallable;
import com.sk89q.intake.parametric.ArgumentParser;
import com.sk89q.intake.parametric.IllegalParameterException;
import com.sk89q.intake.parametric.ParametricBuilder;
import com.sk89q.intake.parametric.handler.InvokeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class MethodCallable
extends AbstractParametricCallable {
    private final Object object;
    private final Method method;
    private final Description description;
    private final List<String> permissions;

    private MethodCallable(ParametricBuilder builder, ArgumentParser parser, Object object, Method method, Description description, List<String> permissions) {
        super(builder, parser);
        this.object = object;
        this.method = method;
        this.description = description;
        this.permissions = permissions;
    }

    @Override
    protected void call(Object[] args) throws InvocationCommandException {
        try {
            this.method.invoke(this.object, args);
        }
        catch (IllegalAccessException e) {
            throw new InvocationCommandException("Could not invoke method '" + this.method + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationCommandException("Could not invoke method '" + this.method + "'", e);
        }
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public boolean testPermission(Namespace namespace) {
        if (this.permissions != null) {
            for (String perm : this.permissions) {
                if (!this.getBuilder().getAuthorizer().testPermission(namespace, perm)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static MethodCallable create(ParametricBuilder builder, Object object, Method method) throws IllegalParameterException {
        Preconditions.checkNotNull((Object)builder, (Object)"builder");
        Preconditions.checkNotNull((Object)object, (Object)"object");
        Preconditions.checkNotNull((Object)method, (Object)"method");
        ImmutableSet commandAnnotations = ImmutableSet.copyOf((Object[])method.getAnnotations());
        Command definition = method.getAnnotation(Command.class);
        Preconditions.checkNotNull((Object)definition, (Object)"Method lacks a @Command annotation");
        boolean ignoreUnusedFlags = definition.anyFlags();
        ImmutableSet unusedFlags = ImmutableSet.copyOf((Collection)Chars.asList((char[])definition.flags().toCharArray()));
        Annotation[][] annotations = method.getParameterAnnotations();
        Type[] types = method.getGenericParameterTypes();
        ArgumentParser.Builder parserBuilder = new ArgumentParser.Builder(builder.getInjector());
        for (int i = 0; i < types.length; ++i) {
            parserBuilder.addParameter(types[i], Arrays.asList(annotations[i]));
        }
        ArgumentParser parser = parserBuilder.build();
        ImmutableDescription.Builder descBuilder = new ImmutableDescription.Builder().setParameters(parser.getUserParameters()).setShortDescription(!definition.desc().isEmpty() ? definition.desc() : null).setHelp(!definition.help().isEmpty() ? definition.help() : null).setUsageOverride(!definition.usage().isEmpty() ? definition.usage() : null);
        Require permHint = method.getAnnotation(Require.class);
        List<String> permissions = null;
        if (permHint != null) {
            descBuilder.setPermissions(Arrays.asList(permHint.value()));
            permissions = Arrays.asList(permHint.value());
        }
        for (InvokeListener listener : builder.getInvokeListeners()) {
            listener.updateDescription((Set<Annotation>)commandAnnotations, parser, descBuilder);
        }
        ImmutableDescription description = descBuilder.build();
        MethodCallable callable = new MethodCallable(builder, parser, object, method, description, permissions);
        callable.setCommandAnnotations((List<? extends Annotation>)ImmutableList.copyOf((Object[])method.getAnnotations()));
        callable.setIgnoreUnusedFlags(ignoreUnusedFlags);
        callable.setUnusedFlags((Set<Character>)unusedFlags);
        return callable;
    }
}

