/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.sk89q.intake.Command;
import com.sk89q.intake.CommandCallable;
import com.sk89q.intake.completion.CommandCompleter;
import com.sk89q.intake.completion.NullCompleter;
import com.sk89q.intake.dispatcher.Dispatcher;
import com.sk89q.intake.parametric.Injector;
import com.sk89q.intake.parametric.MethodCallable;
import com.sk89q.intake.parametric.ParametricException;
import com.sk89q.intake.parametric.handler.ExceptionConverter;
import com.sk89q.intake.parametric.handler.InvokeListener;
import com.sk89q.intake.util.auth.Authorizer;
import com.sk89q.intake.util.auth.NullAuthorizer;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class ParametricBuilder {
    private final Injector injector;
    private final List<InvokeListener> invokeListeners = Lists.newArrayList();
    private final List<ExceptionConverter> exceptionConverters = Lists.newArrayList();
    private Authorizer authorizer = new NullAuthorizer();
    private CommandCompleter defaultCompleter = new NullCompleter();
    private ExecutorService commandExecutor = MoreExecutors.sameThreadExecutor();

    public ParametricBuilder(Injector injector) {
        this.injector = injector;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void addInvokeListener(InvokeListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.invokeListeners.add(listener);
    }

    public void addExceptionConverter(ExceptionConverter converter) {
        Preconditions.checkNotNull((Object)converter);
        this.exceptionConverters.add(converter);
    }

    public ExecutorService getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(ExecutorService commandExecutor) {
        Preconditions.checkNotNull((Object)commandExecutor, (Object)"commandExecutor");
        this.commandExecutor = commandExecutor;
    }

    public void registerMethodsAsCommands(Dispatcher dispatcher, Object object) throws ParametricException {
        Preconditions.checkNotNull((Object)dispatcher);
        Preconditions.checkNotNull((Object)object);
        for (Method method : object.getClass().getDeclaredMethods()) {
            Command definition = method.getAnnotation(Command.class);
            if (definition == null) continue;
            CommandCallable callable = this.build(object, method);
            dispatcher.registerCommand(callable, definition.aliases());
        }
    }

    private CommandCallable build(Object object, Method method) throws ParametricException {
        return MethodCallable.create(this, object, method);
    }

    List<InvokeListener> getInvokeListeners() {
        return this.invokeListeners;
    }

    List<ExceptionConverter> getExceptionConverters() {
        return this.exceptionConverters;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public void setAuthorizer(Authorizer authorizer) {
        Preconditions.checkNotNull((Object)authorizer);
        this.authorizer = authorizer;
    }

    public CommandCompleter getDefaultCompleter() {
        return this.defaultCompleter;
    }

    public void setDefaultCompleter(CommandCompleter defaultCompleter) {
        Preconditions.checkNotNull((Object)defaultCompleter);
        this.defaultCompleter = defaultCompleter;
    }
}

