/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric.handler;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.sk89q.intake.Command;
import com.sk89q.intake.CommandException;
import com.sk89q.intake.ImmutableDescription;
import com.sk89q.intake.argument.ArgumentException;
import com.sk89q.intake.argument.CommandArgs;
import com.sk89q.intake.argument.MissingArgumentException;
import com.sk89q.intake.argument.UnusedArgumentException;
import com.sk89q.intake.parametric.ArgumentParser;
import com.sk89q.intake.parametric.handler.AbstractInvokeListener;
import com.sk89q.intake.parametric.handler.InvokeHandler;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class LegacyCommandsHandler
extends AbstractInvokeListener
implements InvokeHandler {
    @Override
    public InvokeHandler createInvokeHandler() {
        return this;
    }

    @Override
    public boolean preProcess(List<? extends Annotation> annotations, ArgumentParser parser, CommandArgs commandArgs) throws CommandException, ArgumentException {
        return true;
    }

    @Override
    public boolean preInvoke(List<? extends Annotation> annotations, ArgumentParser parser, Object[] args, CommandArgs commandArgs) throws CommandException, ArgumentException {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Command)) continue;
            Command command = (Command)annotation;
            if (commandArgs.size() < command.min()) {
                throw new MissingArgumentException();
            }
            if (command.max() == -1 || commandArgs.size() <= command.max()) continue;
            ArrayList unconsumedArguments = Lists.newArrayList();
            try {
                while (true) {
                    String value = commandArgs.next();
                    if (commandArgs.position() < command.max()) continue;
                    unconsumedArguments.add(value);
                }
            }
            catch (MissingArgumentException ignored) {
                throw new UnusedArgumentException(Joiner.on((String)" ").join((Iterable)unconsumedArguments));
            }
        }
        return true;
    }

    @Override
    public void postInvoke(List<? extends Annotation> annotations, ArgumentParser parser, Object[] args, CommandArgs commandArgs) throws CommandException, ArgumentException {
    }

    @Override
    public void updateDescription(Set<Annotation> annotations, ArgumentParser parser, ImmutableDescription.Builder builder) {
        for (Annotation annotation : annotations) {
            Command command;
            if (!(annotation instanceof Command) || !(command = (Command)annotation).usage().isEmpty() || command.min() <= 0 && command.max() <= 0 || parser.getUserParameters().isEmpty()) continue;
            builder.setUsageOverride("(unknown usage information)");
        }
    }
}

