/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.parametric.provider;

import com.sk89q.intake.argument.ArgumentParseException;
import com.sk89q.intake.parametric.Provider;
import com.sk89q.intake.parametric.annotation.Range;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

abstract class NumberProvider<T extends Number>
implements Provider<T> {
    NumberProvider() {
    }

    @Override
    public boolean isProvided() {
        return false;
    }

    @Override
    public List<String> getSuggestions(String prefix) {
        return Collections.emptyList();
    }

    @Nullable
    protected static Double parseNumericInput(@Nullable String input) throws ArgumentParseException {
        if (input == null) {
            return null;
        }
        try {
            return Double.parseDouble(input);
        }
        catch (NumberFormatException ignored) {
            throw new ArgumentParseException(String.format("Expected '%s' to be a number", input));
        }
    }

    protected static void validate(double number, List<? extends Annotation> modifiers) throws ArgumentParseException {
        for (Annotation annotation : modifiers) {
            if (!(annotation instanceof Range)) continue;
            Range range = (Range)annotation;
            if (number < range.min()) {
                throw new ArgumentParseException(String.format("A valid value is greater than or equal to %s (you entered %s)", range.min(), number));
            }
            if (!(number > range.max())) continue;
            throw new ArgumentParseException(String.format("A valid value is less than or equal to %s (you entered %s)", range.max(), number));
        }
    }

    protected static void validate(int number, List<? extends Annotation> modifiers) throws ArgumentParseException {
        for (Annotation annotation : modifiers) {
            if (!(annotation instanceof Range)) continue;
            Range range = (Range)annotation;
            if ((double)number < range.min()) {
                throw new ArgumentParseException(String.format("A valid value is greater than or equal to %s (you entered %s)", range.min(), number));
            }
            if (!((double)number > range.max())) continue;
            throw new ArgumentParseException(String.format("A valid value is less than or equal to %s (you entered %s)", range.max(), number));
        }
    }
}

