/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.example.parametric;

import com.sk89q.intake.CommandCallable;
import com.sk89q.intake.CommandException;
import com.sk89q.intake.Intake;
import com.sk89q.intake.InvocationCommandException;
import com.sk89q.intake.argument.Namespace;
import com.sk89q.intake.dispatcher.Dispatcher;
import com.sk89q.intake.example.parametric.ExampleAuthorizer;
import com.sk89q.intake.example.parametric.Subject;
import com.sk89q.intake.example.parametric.UniverseCommands;
import com.sk89q.intake.example.parametric.model.Body;
import com.sk89q.intake.example.parametric.model.CelestialType;
import com.sk89q.intake.example.parametric.model.Universe;
import com.sk89q.intake.example.parametric.module.UniverseModule;
import com.sk89q.intake.fluent.CommandGraph;
import com.sk89q.intake.parametric.Injector;
import com.sk89q.intake.parametric.Module;
import com.sk89q.intake.parametric.ParametricBuilder;
import com.sk89q.intake.parametric.provider.PrimitivesModule;
import com.sk89q.intake.util.auth.AuthorizationException;
import com.sk89q.intake.util.auth.Authorizer;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ParametricExample {
    private static final Logger log = Logger.getLogger(ParametricExample.class.getCanonicalName());

    private ParametricExample() {
    }

    public static void main(String[] args) {
        Subject subject = new Subject("example_user");
        subject.permit("body.settype");
        subject.permit("body.settemp");
        subject.permit("body.setdesc");
        subject.permit("body.info");
        Universe universe = new Universe();
        universe.put("mercury", new Body().setType(CelestialType.PLANET));
        universe.put("venus", new Body().setType(CelestialType.PLANET));
        universe.put("earth", new Body().setType(CelestialType.PLANET));
        universe.put("mars", new Body().setType(CelestialType.PLANET));
        universe.put("jupiter", new Body().setType(CelestialType.PLANET));
        universe.put("saturn", new Body().setType(CelestialType.PLANET));
        universe.put("uranus", new Body().setType(CelestialType.PLANET));
        universe.put("neptune", new Body().setType(CelestialType.PLANET));
        universe.put("pluto", new Body().setType(CelestialType.PLANET));
        Namespace namespace = new Namespace();
        namespace.put(Subject.class, (Object)subject);
        Injector injector = Intake.createInjector();
        injector.install((Module)new PrimitivesModule());
        injector.install((Module)new UniverseModule(universe));
        ParametricBuilder builder = new ParametricBuilder(injector);
        builder.setAuthorizer((Authorizer)new ExampleAuthorizer());
        Dispatcher dispatcher = new CommandGraph().builder(builder).commands().group(new String[]{"body"}).registerMethods((Object)new UniverseCommands()).parent().graph().getDispatcher();
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body info pluto");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body settype pluto dwarfplanet");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body info pluto");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body settype poseidon planet");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body settype pluto unknown");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body settemp mercury 167");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body setdesc mercury Closest to the Sun");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body info mercury");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body info -f mercury");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body settemp earth 59 -f");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body info earth");
        ParametricExample.executeCommand(namespace, (CommandCallable)dispatcher, "body delete earth");
    }

    private static void executeCommand(Namespace namespace, CommandCallable callable, String command) {
        System.out.println();
        System.out.println("--------------------");
        System.out.println("/" + command);
        try {
            callable.call(command, namespace, Collections.emptyList());
        }
        catch (CommandException e) {
            System.out.println("Uh oh! Something is wrong: " + e.getMessage());
        }
        catch (AuthorizationException ignored) {
            System.out.println("I'm sorry, Dave. I'm afraid I can't do that.");
        }
        catch (InvocationCommandException e) {
            log.log(Level.WARNING, "Something happened while executing a command", e);
        }
    }
}

