/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.example.parametric;

import com.sk89q.intake.Command;
import com.sk89q.intake.Require;
import com.sk89q.intake.example.parametric.model.Body;
import com.sk89q.intake.example.parametric.model.CelestialType;
import com.sk89q.intake.example.parametric.model.Universe;
import com.sk89q.intake.parametric.annotation.Switch;
import com.sk89q.intake.parametric.annotation.Text;

public class UniverseCommands {
    private static double fahrenheitToCelsius(double temp) {
        return (temp - 32.0) * 5.0 / 9.0;
    }

    private static double celsiusToFahrenheit(double temp) {
        return temp * 9.0 / 5.0 + 32.0;
    }

    @Command(aliases={"settype"}, desc="Set the type of an object")
    @Require(value={"body.settype"})
    public void setType(Body body, CelestialType type) {
        body.setType(type);
    }

    @Command(aliases={"settemp"}, desc="Set the mean temperature of an object")
    @Require(value={"body.settemp"})
    public void setTemp(Body body, double meanTemp, @Switch(value=102) boolean inFahrenheit) {
        if (inFahrenheit) {
            meanTemp = UniverseCommands.fahrenheitToCelsius(meanTemp);
        }
        body.setMeanTemperature(meanTemp);
    }

    @Command(aliases={"setdesc"}, desc="Set the description of an object")
    @Require(value={"body.setdesc"})
    public void setDesc(Body body, @Text String desc) {
        body.setDescription(desc);
    }

    @Command(aliases={"info"}, desc="Show information about an object")
    @Require(value={"body.info"})
    public void info(Body body, @Switch(value=102) boolean inFahrenheit) {
        System.out.println("type: " + (Object)((Object)body.getType()));
        if (inFahrenheit) {
            System.out.println("mean temp: " + UniverseCommands.celsiusToFahrenheit(body.getMeanTemperature()) + " deg F");
        } else {
            System.out.println("mean temp: " + body.getMeanTemperature() + " deg C");
        }
        if (body.getDescription() != null) {
            System.out.println("desc: " + body.getDescription());
        }
    }

    @Command(aliases={"delete"}, desc="Delete a celestial body")
    @Require(value={"body.deathstar"})
    public void delete(Universe universe, String name) {
        universe.remove(name);
    }
}

