/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.example.parametric.model;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import com.sk89q.intake.example.parametric.model.Body;
import java.util.Map;
import javax.annotation.Nullable;

public class Universe {
    private final Map<String, Body> bodies = Maps.newHashMap();

    public void put(String name, Body body) {
        this.bodies.put(name, body);
    }

    @Nullable
    public Body get(String name) {
        Body body = this.bodies.get(name);
        if (body == null) {
            throw new IllegalArgumentException("Couldn't find body with name '" + name + "'");
        }
        return body;
    }

    public Body getIfPresent(String name) {
        return this.bodies.get(name);
    }

    public Map<String, Body> getPrefixedWith(String prefix) {
        ImmutableBiMap.Builder matching = new ImmutableBiMap.Builder();
        for (Map.Entry<String, Body> entry : this.bodies.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            matching.put(entry);
        }
        return matching.build();
    }

    public void remove(String name) {
        this.bodies.remove(name);
    }
}

