/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.example.parametric.module;

import com.google.common.collect.ImmutableList;
import com.sk89q.intake.argument.ArgumentException;
import com.sk89q.intake.argument.ArgumentParseException;
import com.sk89q.intake.argument.CommandArgs;
import com.sk89q.intake.example.parametric.model.Body;
import com.sk89q.intake.example.parametric.model.Universe;
import com.sk89q.intake.parametric.Provider;
import com.sk89q.intake.parametric.ProvisionException;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.Nullable;

public class BodyProvider
implements Provider<Body> {
    private final Universe universe;

    public BodyProvider(Universe universe) {
        this.universe = universe;
    }

    public boolean isProvided() {
        return false;
    }

    @Nullable
    public Body get(CommandArgs arguments, List<? extends Annotation> modifiers) throws ArgumentException, ProvisionException {
        String name = arguments.next();
        Body body = this.universe.getIfPresent(name);
        if (body != null) {
            return body;
        }
        throw new ArgumentParseException("No celestial body by the name of '" + name + "' is known!");
    }

    public List<String> getSuggestions(String prefix) {
        return ImmutableList.copyOf(this.universe.getPrefixedWith(prefix).keySet());
    }
}

