/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.intake.example.sender;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sk89q.intake.Command;
import com.sk89q.intake.CommandException;
import com.sk89q.intake.Intake;
import com.sk89q.intake.InvocationCommandException;
import com.sk89q.intake.argument.Namespace;
import com.sk89q.intake.dispatcher.Dispatcher;
import com.sk89q.intake.dispatcher.SimpleDispatcher;
import com.sk89q.intake.example.sender.Sender;
import com.sk89q.intake.example.sender.SenderModule;
import com.sk89q.intake.example.sender.User;
import com.sk89q.intake.parametric.Injector;
import com.sk89q.intake.parametric.Module;
import com.sk89q.intake.parametric.ParametricBuilder;
import com.sk89q.intake.util.auth.AuthorizationException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class SenderExample {
    private static final Logger log = Logger.getLogger(SenderExample.class.getCanonicalName());

    private SenderExample() {
    }

    public static void main(String[] args) throws AuthorizationException, InvocationCommandException, CommandException {
        ImmutableMap users = new ImmutableMap.Builder().put((Object)"aaron", (Object)new User("Aaron")).put((Object)"michelle", (Object)new User("Michelle")).build();
        Namespace namespace = new Namespace();
        namespace.put((Object)"sender", users.get("aaron"));
        Injector injector = Intake.createInjector();
        injector.install((Module)new SenderModule((Map<String, User>)users));
        ParametricBuilder builder = new ParametricBuilder(injector);
        SimpleDispatcher dispatcher = new SimpleDispatcher();
        builder.registerMethodsAsCommands((Dispatcher)dispatcher, (Object)new SenderExample());
        dispatcher.call("greet", namespace, (List)ImmutableList.of());
        dispatcher.call("privmsg aaron", namespace, (List)ImmutableList.of());
        dispatcher.call("privmsg michelle", namespace, (List)ImmutableList.of());
        dispatcher.call("poke aaron", namespace, (List)ImmutableList.of());
        dispatcher.call("poke michelle", namespace, (List)ImmutableList.of());
    }

    @Command(aliases={"greet"}, desc="Greet the sender")
    public void greet(@Sender User user) {
        user.message("Hi!");
    }

    @Command(aliases={"privmsg"}, desc="Send a message to someone")
    public void privMsg(@Sender User user, User target) {
        target.message("Hi from " + user.getName());
    }

    @Command(aliases={"poke"}, desc="Poke someone anonymously")
    public void poke(User target) {
        target.message("You've been poked!");
    }
}

