/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.lpbuilder;

import com.sk89q.mclauncher.util.LauncherUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileSignatureBuilder {
    private final Logger logger = Logger.getLogger(FileSignatureBuilder.class.getCanonicalName());
    private static final boolean DEBUG = System.getProperty("com.sk89q.lpbuilder.FileSignatureBuilder.debug", "false").equalsIgnoreCase("true");
    private static final Pattern ZIP_NAMES = Pattern.compile("^.*\\.(zip|jar)$", 2);

    public MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fromZipContents(File file) throws IOException {
        byte[] byArray;
        SignatureList list = new SignatureList();
        FileInputStream fis = null;
        ZipInputStream zip = null;
        try {
            ZipEntry entry;
            fis = new FileInputStream(file);
            zip = new ZipInputStream(fis);
            while ((entry = zip.getNextEntry()) != null) {
                list.add(entry.getName(), this.fromInputStream(zip));
            }
            byArray = list.toDigest();
        }
        catch (Throwable throwable) {
            LauncherUtils.close(zip);
            LauncherUtils.close(fis);
            throw throwable;
        }
        LauncherUtils.close(zip);
        LauncherUtils.close(fis);
        return byArray;
    }

    public byte[] smartFromFile(File file) throws IOException {
        try {
            if (ZIP_NAMES.matcher(file.getName()).matches()) {
                return this.fromZipContents(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.fromFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fromFile(File file) throws IOException {
        byte[] byArray;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            byArray = this.fromInputStream(bis);
        }
        catch (Throwable throwable) {
            LauncherUtils.close(bis);
            LauncherUtils.close(fis);
            throw throwable;
        }
        LauncherUtils.close(bis);
        LauncherUtils.close(fis);
        return byArray;
    }

    public byte[] fromInputStream(InputStream is) throws IOException {
        int len;
        MessageDigest digest = this.createDigest();
        byte[] buf = new byte[2048];
        while ((len = is.read(buf, 0, buf.length)) != -1) {
            digest.update(buf, 0, len);
        }
        return digest.digest();
    }

    public SignatureList createList() {
        return new SignatureList();
    }

    private static class FileSignature
    implements Comparable<FileSignature> {
        private final String key;
        private final byte[] digest;

        public FileSignature(String key, byte[] digest) {
            this.key = key;
            this.digest = digest;
        }

        @Override
        public int compareTo(FileSignature o) {
            return this.key.compareTo(o.key);
        }
    }

    public class SignatureList {
        private final List<FileSignature> files = new ArrayList<FileSignature>();

        public void add(String key, byte[] hash) {
            MessageDigest digest = FileSignatureBuilder.this.createDigest();
            digest.update(hash);
            this.files.add(new FileSignature(key, hash));
        }

        public byte[] toDigest() {
            if (DEBUG) {
                FileSignatureBuilder.this.logger.info("------------------- Signature List -------------------");
            }
            Collections.sort(this.files);
            MessageDigest digest = FileSignatureBuilder.this.createDigest();
            for (FileSignature file : this.files) {
                digest.update(file.key.getBytes());
                digest.update((byte)0);
                digest.update(file.digest);
                if (!DEBUG) continue;
                FileSignatureBuilder.this.logger.info(LauncherUtils.getHexString(file.digest) + " " + file.key);
            }
            if (DEBUG) {
                FileSignatureBuilder.this.logger.info("------------------------------------------------------");
            }
            return digest.digest();
        }
    }
}

