/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.lpbuilder;

import java.util.Collection;
import java.util.EnumSet;
import javax.xml.bind.annotation.XmlValue;
import util.FnMatch;

public abstract class PathPattern {
    private static EnumSet<FnMatch.Flag> fnMatchFlags = EnumSet.of(FnMatch.Flag.CASEFOLD, FnMatch.Flag.PERIOD);
    private String value;

    public PathPattern() {
    }

    public PathPattern(String value) {
        this.value = value;
    }

    @XmlValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static boolean matches(Collection<PathPattern> patterns, String path) {
        boolean matches = false;
        for (PathPattern pattern : patterns) {
            if (!FnMatch.fnmatch(pattern.getValue(), path, fnMatchFlags)) continue;
            if (pattern instanceof Include) {
                matches = true;
                continue;
            }
            if (!(pattern instanceof Exclude)) continue;
            matches = false;
        }
        return matches;
    }

    public static class Exclude
    extends PathPattern {
        public Exclude() {
        }

        public Exclude(String value) {
            super(value);
        }
    }

    public static class Include
    extends PathPattern {
        public Include() {
        }

        public Include(String value) {
            super(value);
        }
    }
}

