/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.lpbuilder;

import com.sk89q.lpbuilder.FilePattern;
import com.sk89q.lpbuilder.FileSignatureBuilder;
import com.sk89q.lpbuilder.Role;
import com.sk89q.lpbuilder.UpdateBuilderConfig;
import com.sk89q.lpbuilder.ZipBucket;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.model.FileGroup;
import com.sk89q.mclauncher.model.PackageFile;
import com.sk89q.mclauncher.model.PackageManifest;
import com.sk89q.mclauncher.model.SingleFile;
import com.sk89q.mclauncher.model.UpdateManifest;
import com.sk89q.mclauncher.util.BasicArgsParser;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.SimpleLogFormatter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import lzma.sdk.lzma.Encoder;
import lzma.streams.LzmaOutputStream;

public class UpdateBuilder
implements Runnable {
    private static final Logger logger = Logger.getLogger(UpdateBuilder.class.getCanonicalName());
    private final File updateDir;
    private final File outputDir;
    private final Map<String, ZipBucket> buckets = new HashMap<String, ZipBucket>();
    private final FileSignatureBuilder versionBuilder = new FileSignatureBuilder();
    private Role role = Role.CLIENT;
    private UpdateManifest updateManifest;
    private PackageManifest packageManifest;
    private UpdateBuilderConfig config = new UpdateBuilderConfig();
    private String updateFilename = "update.xml";
    private String packageFilename = "package.xml";

    public UpdateBuilder(File updateDir, File outputDir) {
        this.updateDir = updateDir;
        this.outputDir = outputDir;
        outputDir.mkdirs();
        this.setUpdateManifest(new UpdateManifest());
        this.setPackageManifest(new PackageManifest());
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    private boolean isForCurrentRole(File dir) {
        if (this.role == null) {
            return false;
        }
        return dir.getName().equals(this.role.getDirectoryName());
    }

    private boolean shouldRoleIgnore(File dir) {
        for (Role role : Role.values()) {
            if (this.role != null && role.equals((Object)this.role) || !role.getDirectoryName().equals(dir.getName())) continue;
            return true;
        }
        return false;
    }

    public String getUpdateFilename() {
        return this.updateFilename;
    }

    public void setUpdateFilename(String updateFilename) {
        this.updateFilename = updateFilename;
    }

    public String getPackageFilename() {
        return this.packageFilename;
    }

    public void setPackageFilename(String packageFilename) {
        this.packageFilename = packageFilename;
    }

    public UpdateBuilderConfig getConfiguration() {
        return this.config;
    }

    public void setConfiguration(UpdateBuilderConfig config) {
        this.config = config;
    }

    public UpdateManifest getUpdateManifest() {
        return this.updateManifest;
    }

    public void setUpdateManifest(UpdateManifest updateManifest) {
        this.updateManifest = updateManifest;
    }

    public PackageManifest getPackageManifest() {
        return this.packageManifest;
    }

    public void setPackageManifest(PackageManifest packageManifest) {
        this.packageManifest = packageManifest;
        packageManifest.setVersion("1.2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfiguration(File file) throws FileNotFoundException, JAXBException {
        UpdateBuilderConfig config;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{UpdateBuilderConfig.class});
        Unmarshaller um = context.createUnmarshaller();
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            config = (UpdateBuilderConfig)um.unmarshal((Reader)new FileReader(file));
        }
        catch (Throwable throwable) {
            LauncherUtils.close(reader);
            throw throwable;
        }
        LauncherUtils.close(reader);
        UpdateBuilderConfig.Templates templates = config.getTemplates();
        this.setPackageManifest(templates.getPackageManifest());
        this.setUpdateManifest(templates.getUpdateManifest());
        this.config = config;
    }

    private void collectFiles() throws IOException, InterruptedException {
        this.collectFiles(this.updateDir, "", this.updateDir, null);
    }

    private void collectFiles(File baseDir, String relativeDir, File dir, FileGroup group) throws IOException, InterruptedException {
        logger.info("Collecting files in '" + dir.getAbsolutePath() + "'");
        boolean addGroup = false;
        if (group == null) {
            group = new FileGroup();
            String withSlash = relativeDir;
            if (!withSlash.isEmpty()) {
                withSlash = withSlash + "/";
            }
            group.setDest(withSlash);
            group.setSource(withSlash);
            addGroup = true;
        }
        for (File f : dir.listFiles()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (f.isDirectory()) {
                if (this.shouldRoleIgnore(f)) continue;
                if (this.isForCurrentRole(f)) {
                    this.collectFiles(baseDir, relativeDir, f, group);
                    continue;
                }
                this.collectFiles(baseDir, LauncherUtils.joinUnixPath(relativeDir, f.getName()), f, null);
                continue;
            }
            String fileRelative = LauncherUtils.joinUnixPath(relativeDir, f.getName());
            logger.info("-> " + LauncherUtils.getRelative(baseDir, f));
            SingleFile singleFile = this.createSingleFile(fileRelative, f);
            if (singleFile == null) continue;
            singleFile.setSize(f.length());
            singleFile.setVersion(this.versionBuilder.smartFromFile(f));
            singleFile.setFilename(f.getName());
            UpdateBuilder.copyFile(f, new File(this.outputDir, fileRelative));
            group.getFiles().add(singleFile);
        }
        if (addGroup && group.getFiles().size() > 0) {
            this.packageManifest.getFileGroups().add(group);
        }
    }

    private SingleFile createSingleFile(String path, File file) {
        SingleFile singleFile = new SingleFile();
        String archiveName = null;
        List<FilePattern> filePatterns = this.config.getFilePatterns();
        if (filePatterns != null) {
            for (FilePattern pattern : filePatterns) {
                if (!pattern.matchesPath(path)) continue;
                singleFile.inheritGenericProperties(pattern);
                if (pattern.getArchiveName() == null) continue;
                archiveName = pattern.getArchiveName();
            }
        }
        if (archiveName != null) {
            this.storeFileInArchive(archiveName, path, file, singleFile);
            return null;
        }
        return singleFile;
    }

    private void storeFileInArchive(String archiveName, String path, File file, PackageFile packageFile) {
        ZipBucket bucket = this.buckets.get(archiveName = archiveName.trim());
        if (bucket == null) {
            bucket = new ZipBucket();
            this.buckets.put(archiveName, bucket);
        }
        bucket.inheritGenericProperties(packageFile);
        bucket.queue(path, file);
    }

    private void commitBuckets() throws IOException, InterruptedException {
        logger.info("Writing ZIPs that are to be extracted later...");
        FileGroup group = new FileGroup();
        group.setDest(".");
        group.setSource("");
        for (Map.Entry<String, ZipBucket> entry : this.buckets.entrySet()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            String filename = entry.getKey();
            File target = new File(this.outputDir, filename);
            target.getParentFile().mkdirs();
            logger.info("-> " + filename);
            ZipBucket bucket = entry.getValue();
            bucket.writeContents(this.versionBuilder, this.updateDir, target);
            bucket.setSize(target.length());
            bucket.setFilename(filename);
            List<FilePattern> filePatterns = this.config.getFilePatterns();
            if (filePatterns != null) {
                for (FilePattern pattern : filePatterns) {
                    if (!pattern.matchesPath(filename)) continue;
                    logger.info("    Pattern: " + filename + ": " + pattern);
                    bucket.inheritGenericProperties(pattern);
                }
            }
            group.getFiles().add(bucket);
        }
        if (group.getFiles().size() > 0) {
            this.packageManifest.getFileGroups().add(group);
        }
    }

    public void build() throws JAXBException, IOException, InterruptedException {
        logger.info("Output directory: " + this.outputDir.getAbsolutePath());
        this.collectFiles();
        this.commitBuckets();
        this.getUpdateManifest().setPackageURL(this.getPackageFilename());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PackageManifest.class, UpdateManifest.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        File packageFile = new File(this.outputDir, this.getPackageFilename());
        File updateFile = new File(this.outputDir, this.getUpdateFilename());
        this.marshal(m, this.getPackageManifest(), packageFile);
        this.marshal(m, this.getUpdateManifest(), updateFile);
        logger.info("Package manifest: " + packageFile.getAbsolutePath());
        logger.info("Update manifest: " + updateFile.getAbsolutePath());
        logger.info("------------------------------------------------------------------------");
        logger.info("Update package created!");
        logger.info("(1) Upload the entirety of '" + this.outputDir.getAbsolutePath() + "' to somewhere on the Internet.");
        logger.info("(2) Install in the launcher with:");
        logger.info("    http://YOUR_DOMAIN.com/WHERE_YOU_UPLOADED_IT/" + this.updateFilename);
        logger.info("------------------------------------------------------------------------");
    }

    @Override
    public void run() {
        try {
            UpdateBuilder.build(this);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Build cancelled!", e);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "An error has occurred: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshal(Marshaller m, Object object, File file) throws JAXBException, IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            BufferedOutputStream buf = new BufferedOutputStream(fos);
            m.marshal(object, (OutputStream)buf);
            buf.close();
        }
        catch (Throwable throwable) {
            LauncherUtils.close(fos);
            throw throwable;
        }
        LauncherUtils.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileLzma(File sourceFile, File destFile) throws IOException {
        destFile.getParentFile().mkdirs();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        LzmaOutputStream compress = null;
        try {
            int length;
            fis = new FileInputStream(sourceFile);
            bis = new BufferedInputStream(fis);
            fos = new FileOutputStream(destFile);
            bos = new BufferedOutputStream(fos);
            compress = new LzmaOutputStream((OutputStream)bos, new Encoder());
            byte[] buffer = new byte[8192];
            while ((length = bis.read(buffer)) > 0) {
                compress.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            LauncherUtils.close(bis);
            LauncherUtils.close(fis);
            LauncherUtils.close(compress);
            LauncherUtils.close(bos);
            LauncherUtils.close(fos);
            throw throwable;
        }
        LauncherUtils.close(bis);
        LauncherUtils.close(fis);
        LauncherUtils.close(compress);
        LauncherUtils.close(bos);
        LauncherUtils.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        destFile.getParentFile().mkdirs();
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        FileChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            destination.transferFrom(source, 0L, source.size());
        }
        catch (Throwable throwable) {
            LauncherUtils.close(source);
            LauncherUtils.close(destination);
            throw throwable;
        }
        LauncherUtils.close(source);
        LauncherUtils.close(destination);
    }

    private static void checkArgSet(Object obj, String message) {
        if (obj == null) {
            logger.warning(message);
            System.exit(1);
        }
    }

    public static void clean(File dir) throws InterruptedException {
        logger.info("");
        logger.info("---------------------------------------------------");
        logger.info("Cleaning target directory");
        logger.info("---------------------------------------------------");
        LauncherUtils.cleanDir(dir);
        logger.info("Deleted the contents of " + dir.getAbsolutePath());
    }

    public static void build(UpdateBuilder builder) throws JAXBException, IOException, InterruptedException {
        logger.info("");
        logger.info("---------------------------------------------------");
        logger.info("Building update package");
        logger.info("---------------------------------------------------");
        builder.build();
    }

    public static void main(String[] args) throws Throwable {
        BasicArgsParser.ArgsContext context;
        SimpleLogFormatter.setAsFormatter();
        logger.info("Easy Update Builder for SKMCLauncher");
        logger.info("http://github.com/sk89q/skmclauncher");
        BasicArgsParser parser = new BasicArgsParser();
        parser.addValueArg("dir");
        parser.addValueArg("out");
        parser.addValueArg("id");
        parser.addValueArg("name");
        parser.addValueArg("version");
        parser.addValueArg("package-filename");
        parser.addValueArg("update-filename");
        parser.addValueArg("config");
        parser.addFlagArg("clean");
        try {
            context = parser.parse(args);
        }
        catch (IllegalArgumentException e) {
            logger.warning("Error: " + e.getMessage());
            System.exit(1);
            return;
        }
        String filesDirStr = context.get("dir");
        UpdateBuilder.checkArgSet(filesDirStr, "Use -dir to set a directory containing the files");
        String outputDirStr = context.get("out");
        UpdateBuilder.checkArgSet(outputDirStr, "Use -output to set an output directory");
        String id = context.get("id");
        String name = context.get("name");
        String version = context.get("version");
        String packageFilename = context.get("package-filename");
        String updateFilename = context.get("update-filename");
        String configPath = context.get("config");
        File updateDir = new File(filesDirStr);
        File outputDir = new File(outputDirStr);
        if (updateDir.equals(outputDir)) {
            logger.warning("Cannot use the same source dir as the output dir");
            System.exit(2);
        }
        if (context.has("clean")) {
            UpdateBuilder.clean(outputDir);
        }
        UpdateBuilder builder = new UpdateBuilder(updateDir, outputDir);
        if (configPath != null) {
            builder.loadConfiguration(new File(configPath));
        }
        if (packageFilename != null) {
            builder.setPackageFilename(packageFilename);
        }
        if (updateFilename != null) {
            builder.setUpdateFilename(updateFilename);
        }
        UpdateManifest updateManifest = builder.getUpdateManifest();
        if (id != null) {
            updateManifest.setId(id);
        }
        if (name != null) {
            updateManifest.setName(name);
        }
        if (updateManifest.getId() == null) {
            logger.warning("Update ID not set! Use -config and specify a configuration. Now using default ID of 'my-modpack'");
            builder.getUpdateManifest().setId("my-modpack");
        }
        if (!Configuration.isValidId(updateManifest.getId())) {
            logger.warning("Invalid update ID! ID must match ^[A-Za-z0-9\\-_\\.]+$ with recommended length <= 30 chars");
            System.exit(3);
        }
        if (updateManifest.getName() == null) {
            logger.warning("Update name not set! Use -config and specify a configuration. Now using default name of 'My ModPack'");
            builder.getUpdateManifest().setName("My ModPack");
        }
        if (version != null) {
            updateManifest.setLatestVersion(version);
        } else {
            updateManifest.setLatestVersion(new Date().toString());
        }
        UpdateBuilder.build(builder);
    }
}

