/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.lpbuilder;

import com.sk89q.lpbuilder.FilePattern;
import com.sk89q.lpbuilder.PathPattern;
import com.sk89q.lpbuilder.UpdateBuilder;
import com.sk89q.lpbuilder.UpdateBuilderConfig;
import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.model.FileGroup;
import com.sk89q.mclauncher.model.PackageManifest;
import com.sk89q.mclauncher.model.UpdateManifest;
import com.sk89q.mclauncher.util.ActionListeners;
import com.sk89q.mclauncher.util.DirectoryField;
import com.sk89q.mclauncher.util.FileField;
import com.sk89q.mclauncher.util.LinkButton;
import com.sk89q.mclauncher.util.MessageLog;
import com.sk89q.mclauncher.util.SimpleLogFormatter;
import com.sk89q.mclauncher.util.SwingHelper;
import com.sk89q.mclauncher.util.Task;
import com.sk89q.mclauncher.util.XmlUtils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class UpdateBuilderGUI
extends JFrame {
    private static final long serialVersionUID = 48131029351157284L;
    private static final Logger logger = Logger.getLogger(UpdateBuilderGUI.class.getCanonicalName());
    private final UpdateBuilderGUI self = this;
    private final MessageLog messageLog;
    private FileField configField;
    private JTextField idText;
    private JTextField nameText;
    private JTextField versionText;
    private DirectoryField sourceField;
    private DirectoryField outputField;
    private JTextField packageText;
    private JTextField updateText;
    private JCheckBox includeLibsCheck;
    private JCheckBox cleanCheck;
    private JCheckBox zipConfigsCheck;
    private JButton buildButton;
    private Thread buildThread;

    public UpdateBuilderGUI() {
        this.setTitle("Update Package Builder");
        this.setSize(450, 600);
        SwingHelper.setIconImage(this, "/resources/icon.png");
        this.setLocationRelativeTo(null);
        this.messageLog = new MessageLog(1000, true);
        this.messageLog.registerLoggerHandler();
        this.addComponents();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                UpdateBuilderGUI.this.close();
            }
        });
    }

    private void close() {
        this.setBuilding(false);
        this.messageLog.detachGlobalHandler();
        this.self.dispose();
    }

    private void build() {
        try {
            this.completeBuild();
        }
        catch (Task.ExecutionException e) {
            SwingHelper.showError(this, "Error with parameters", e.getMessage());
        }
        catch (Throwable e) {
            SwingHelper.showError(this, "Error", "Something went wrong: " + e.toString());
            logger.log(Level.WARNING, "Error", e);
        }
    }

    private void cancel() {
        Thread thread = this.buildThread;
        if (thread != null) {
            thread.interrupt();
            this.buildThread = null;
        }
    }

    private void completeBuild() throws Throwable {
        if (this.buildThread != null) {
            this.cancel();
            return;
        }
        String configPath = UpdateBuilderGUI.validate("Builder configuration", this.configField.getPath(), false, null);
        String id = UpdateBuilderGUI.validate("ID", this.idText.getText(), false, Configuration.ID_PATTERN);
        String name = UpdateBuilderGUI.validate("Name", this.nameText.getText(), false, null);
        String version = UpdateBuilderGUI.validate("Version", this.versionText.getText(), false, null);
        File sourceDir = UpdateBuilderGUI.validateDirectory("Source directory", this.sourceField.getPath(), false);
        final File outputDir = UpdateBuilderGUI.validateDirectory("Output directory", this.outputField.getPath(), true);
        String packageFilename = UpdateBuilderGUI.validate("Package filename", this.packageText.getText(), true, null);
        String updateFilename = UpdateBuilderGUI.validate("Update filename", this.updateText.getText(), true, null);
        boolean includeLibs = this.includeLibsCheck.isSelected();
        final boolean clean = this.cleanCheck.isSelected();
        boolean zipConfigs = this.zipConfigsCheck.isSelected();
        if (sourceDir.equals(outputDir)) {
            throw new Task.ExecutionException("The output directory cannot be the same as the source directory!");
        }
        if (clean && JOptionPane.showConfirmDialog(this, "Continue and delete everything in " + outputDir.getAbsolutePath() + "?", "Clean Directory", 0) != 0) {
            return;
        }
        final UpdateBuilder builder = new UpdateBuilder(sourceDir, outputDir);
        if (configPath != null) {
            builder.loadConfiguration(new File(configPath));
        }
        UpdateManifest updateManifest = builder.getUpdateManifest();
        updateManifest.setLatestVersion(version);
        if (packageFilename != null) {
            builder.setPackageFilename(packageFilename);
        }
        if (updateFilename != null) {
            builder.setUpdateFilename(updateFilename);
        }
        if (id != null) {
            updateManifest.setId(id);
        }
        if (name != null) {
            updateManifest.setName(name);
        }
        if (updateManifest.getId() == null) {
            throw new Task.ExecutionException("Package ID not set!");
        }
        if (!Configuration.isValidId(updateManifest.getId())) {
            throw new Task.ExecutionException("The package ID (from the builder configuration) is invalid!");
        }
        if (updateManifest.getName() == null) {
            throw new Task.ExecutionException("Package name not set!");
        }
        List<FileGroup> fileGroups = builder.getPackageManifest().getFileGroups();
        UpdateBuilderConfig config = builder.getConfiguration();
        if (includeLibs) {
            PackageManifest libsManifest = XmlUtils.parseJaxb(PackageManifest.class, Launcher.class.getResourceAsStream("/resources/libs_builder_config.xml"));
            for (FileGroup group : libsManifest.getFileGroups()) {
                fileGroups.add(group);
            }
        }
        if (zipConfigs) {
            FilePattern pattern = new FilePattern();
            pattern.getPathPatterns().add(new PathPattern.Include("config/*"));
            pattern.setArchiveName("configs.extract.zip");
            config.getFilePatterns().add(pattern);
        }
        this.messageLog.clear();
        this.buildThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (clean) {
                        UpdateBuilder.clean(outputDir);
                    }
                    builder.run();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    UpdateBuilderGUI.this.setBuilding(false);
                }
            }
        });
        this.buildThread.setName("Builder");
        this.buildThread.start();
        this.setBuilding(true);
    }

    private void setBuilding(boolean building) {
        if (building) {
            this.buildButton.setText("Cancel Build");
        } else {
            this.cancel();
            this.buildButton.setText("Build Package...");
        }
    }

    private static File validateDirectory(String name, String path, boolean mkdirs) throws Task.ExecutionException {
        if ((path = path.trim()).isEmpty()) {
            throw new Task.ExecutionException("Required field '" + name + "' not set.");
        }
        File file = new File(path);
        if (mkdirs) {
            file.mkdirs();
        }
        if (!file.exists()) {
            throw new Task.ExecutionException("The path '" + path + "' doesn't exist.");
        }
        if (!file.isDirectory()) {
            throw new Task.ExecutionException("The path '" + path + "' is not a directory.");
        }
        return file;
    }

    private static String validate(String name, String text, boolean required, Pattern pattern) throws Task.ExecutionException {
        text = text.trim();
        if (required) {
            if (text.isEmpty()) {
                throw new Task.ExecutionException("Required field '" + name + "' not set.");
            }
        } else if (text.isEmpty()) {
            return null;
        }
        if (pattern != null && !pattern.matcher(text).matches()) {
            throw new Task.ExecutionException("Required field '" + name + "' has invalid characters.\n\n" + "(Must match regex. " + pattern.toString() + ")");
        }
        return text;
    }

    private void addComponents() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        fieldConstraints.fill = 2;
        fieldConstraints.weightx = 1.0;
        fieldConstraints.gridwidth = 0;
        fieldConstraints.insets = new Insets(2, 1, 2, 1);
        GridBagConstraints labelConstraints = (GridBagConstraints)fieldConstraints.clone();
        labelConstraints.weightx = 0.0;
        labelConstraints.gridwidth = 1;
        labelConstraints.insets = new Insets(1, 1, 1, 10);
        GridBagConstraints fullFieldConstraints = (GridBagConstraints)fieldConstraints.clone();
        fullFieldConstraints.insets = new Insets(5, 2, 1, 2);
        final JLabel buildConfigLabel = new JLabel("Build configuration:");
        panel.add((Component)buildConfigLabel, labelConstraints);
        this.configField = new FileField("Select builder configuration", "Builder configuration");
        buildConfigLabel.setLabelFor(this.configField);
        panel.add((Component)this.configField, fieldConstraints);
        this.configField.setVisible(false);
        buildConfigLabel.setVisible(false);
        JButton useConfigBtn = new JButton("Use Builder Configuration");
        final JPanel useConfigPanel = new JPanel();
        useConfigPanel.add(new JLabel("Have a configuration file? "));
        useConfigPanel.setLayout(new FlowLayout(2, 0, 0));
        useConfigPanel.add(useConfigBtn);
        useConfigBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                buildConfigLabel.setVisible(true);
                UpdateBuilderGUI.this.configField.setVisible(true);
                useConfigPanel.setVisible(false);
            }
        });
        panel.add((Component)useConfigPanel, fullFieldConstraints);
        panel.add(Box.createVerticalStrut(3), fullFieldConstraints);
        JLabel label = new JLabel("Package ID:");
        panel.add((Component)label, labelConstraints);
        this.idText = new JTextField();
        this.idText.setText("my-mod-pack");
        label.setLabelFor(this.idText);
        panel.add((Component)this.idText, fieldConstraints);
        label = new JLabel("Package name:");
        panel.add((Component)label, labelConstraints);
        this.nameText = new JTextField();
        this.nameText.setText("My Mod Pack");
        label.setLabelFor(this.nameText);
        panel.add((Component)this.nameText, fieldConstraints);
        label = new JLabel("Version:");
        panel.add((Component)label, labelConstraints);
        this.versionText = new JTextField();
        this.versionText.setText(new Date().toString());
        label.setLabelFor(this.versionText);
        panel.add((Component)this.versionText, fieldConstraints);
        label = new JLabel("Source directory:");
        panel.add((Component)label, labelConstraints);
        this.sourceField = new DirectoryField();
        label.setLabelFor(this.sourceField);
        panel.add((Component)this.sourceField, fieldConstraints);
        panel.add(Box.createGlue(), labelConstraints);
        this.includeLibsCheck = new JCheckBox("Add Mojang's LWJGL into package");
        this.includeLibsCheck.setBorder(null);
        this.includeLibsCheck.setSelected(true);
        panel.add((Component)this.includeLibsCheck, fieldConstraints);
        panel.add(Box.createGlue(), labelConstraints);
        this.zipConfigsCheck = new JCheckBox("Put files from config/ into one .zip");
        this.zipConfigsCheck.setBorder(null);
        this.zipConfigsCheck.setSelected(true);
        panel.add((Component)this.zipConfigsCheck, fieldConstraints);
        label = new JLabel("Output directory:");
        panel.add((Component)label, labelConstraints);
        this.outputField = new DirectoryField();
        label.setLabelFor(this.outputField);
        panel.add((Component)this.outputField, fieldConstraints);
        panel.add(Box.createGlue(), labelConstraints);
        this.cleanCheck = new JCheckBox("Delete everything in the output directory first");
        this.cleanCheck.setBorder(null);
        this.cleanCheck.setSelected(true);
        panel.add((Component)this.cleanCheck, fieldConstraints);
        label = new JLabel("Package filename:");
        panel.add((Component)label, labelConstraints);
        this.packageText = new JTextField();
        this.packageText.setText("package.xml");
        label.setLabelFor(this.packageText);
        panel.add((Component)this.packageText, fieldConstraints);
        label = new JLabel("Update filename:");
        panel.add((Component)label, labelConstraints);
        this.updateText = new JTextField();
        this.updateText.setText("update.xml");
        label.setLabelFor(this.updateText);
        panel.add((Component)this.updateText, fieldConstraints);
        this.add((Component)panel, "North");
        this.add((Component)this.messageLog, "Center");
        Box buttonsPanel = Box.createHorizontalBox();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        LinkButton helpButton = new LinkButton("Help! What do I do?");
        this.buildButton = new JButton("Build Package...");
        JButton closeButton = new JButton("Close");
        buttonsPanel.add(helpButton);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.buildButton);
        buttonsPanel.add(Box.createHorizontalStrut(6));
        buttonsPanel.add(closeButton);
        this.add((Component)buttonsPanel, "South");
        helpButton.addActionListener(ActionListeners.openURL(this, "https://github.com/sk89q/skmclauncher/blob/master/README.md"));
        this.buildButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateBuilderGUI.this.build();
            }
        });
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UpdateBuilderGUI.this.close();
            }
        });
        SwingHelper.focusLater(this.idText);
    }

    public static void main(String[] args) {
        SimpleLogFormatter.setAsFormatter();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingHelper.setLookAndFeel();
                UpdateBuilderGUI gui = new UpdateBuilderGUI();
                gui.setVisible(true);
            }
        });
    }
}

