/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.lpbuilder;

import com.sk89q.lpbuilder.FileSignatureBuilder;
import com.sk89q.lpbuilder.RelativizedFile;
import com.sk89q.mclauncher.model.Archive;
import com.sk89q.mclauncher.util.LauncherUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class ZipBucket
extends Archive {
    private final List<RelativizedFile> contents = new ArrayList<RelativizedFile>();

    ZipBucket() {
    }

    void queue(String path, File file) {
        this.contents.add(new RelativizedFile(path, file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContents(FileSignatureBuilder builder, File baseDir, File target) throws IOException {
        FileSignatureBuilder.SignatureList list = builder.createList();
        FileOutputStream fos = null;
        ZipOutputStream zip = null;
        FileInputStream fis = null;
        byte[] buf = new byte[8192];
        try {
            fos = new FileOutputStream(target);
            zip = new ZipOutputStream(fos);
            for (RelativizedFile file : this.contents) {
                int count;
                zip.putNextEntry(new ZipEntry(file.getPath()));
                list.add(file.getPath(), builder.fromFile(file.getFile()));
                fis = new FileInputStream(file.getFile());
                while ((count = fis.read(buf)) > 0) {
                    zip.write(buf, 0, count);
                }
                LauncherUtils.close(fis);
            }
            this.setVersion(list.toDigest());
        }
        catch (Throwable throwable) {
            LauncherUtils.close(zip);
            LauncherUtils.close(fos);
            LauncherUtils.close(fis);
            throw throwable;
        }
        LauncherUtils.close(zip);
        LauncherUtils.close(fos);
        LauncherUtils.close(fis);
    }
}

