/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.addons.Addon;
import com.sk89q.mclauncher.addons.AddonsProfile;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.Task;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class AddonInstallerTask
extends Task {
    private static final Logger logger = Logger.getLogger(AddonInstallerTask.class.getCanonicalName());
    private AddonsProfile addonsProfile;
    private File file;
    private boolean removeOther = false;

    public AddonInstallerTask(AddonsProfile addonsProfile, File file) {
        this.addonsProfile = addonsProfile;
        this.file = file;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void execute() throws Task.ExecutionException, InterruptedException {
        JarEntry entry;
        boolean needToMunge;
        String id;
        this.fireTitleChange("Installing addon...");
        this.fireStatusChange("Installing " + this.file.getName() + "...");
        this.fireValueChange(-1.0);
        String name = id = this.file.getName().replaceAll("\\..[^\\.]+$", "");
        String detectedModLoaderName = null;
        boolean multipleModLoaderMods = false;
        FileInputStream in = null;
        JarInputStream jarFile = null;
        int entriesCount = 0;
        boolean hasRoot = false;
        boolean foundClasses = false;
        String mungePath = null;
        boolean multipleMunge = false;
        boolean hasMcmodInfo = false;
        Pattern classRE = Pattern.compile("^.*\\.class$");
        Pattern modLoaderNameRE = Pattern.compile("^(?:.*/)?mod_([A-Za-z0-9_]+)\\.class$");
        this.fireStatusChange("Scanning addon files...");
        try {
            JarEntry entry2;
            in = new FileInputStream(this.file);
            jarFile = new JarInputStream(new BufferedInputStream(in));
            while ((entry2 = jarFile.getNextJarEntry()) != null) {
                LauncherUtils.checkInterrupted();
                if (entry2.isDirectory()) continue;
                ++entriesCount;
                String path = entry2.getName().replace("\\", "/");
                if (path.equals("mcmod.info")) {
                    hasMcmodInfo = true;
                }
                if (path.startsWith("/")) continue;
                Matcher matcher = modLoaderNameRE.matcher(path);
                if (matcher.matches()) {
                    if (detectedModLoaderName != null) {
                        multipleModLoaderMods = true;
                    } else {
                        detectedModLoaderName = matcher.group(1);
                    }
                }
                if (hasRoot || !classRE.matcher(path).matches()) continue;
                foundClasses = true;
                if (path.indexOf(47) == -1) {
                    hasRoot = true;
                    continue;
                }
                int lastSlash = path.lastIndexOf(47);
                String folderPath = path.substring(0, lastSlash + 1);
                if (mungePath != null) {
                    if (mungePath.startsWith(folderPath)) {
                        mungePath = folderPath;
                        continue;
                    }
                    if (folderPath.startsWith(mungePath)) continue;
                    String[] parts1 = mungePath.split("/");
                    String[] parts2 = folderPath.split("/");
                    StringBuilder finalPathBuilder = new StringBuilder();
                    int num = Math.min(parts1.length, parts2.length);
                    for (int i = 0; i < num; ++i) {
                        if (!parts1[i].equals(parts2[i])) continue;
                        finalPathBuilder.append(parts1[i]);
                        finalPathBuilder.append('/');
                    }
                    if (finalPathBuilder.length() > 0) {
                        mungePath = finalPathBuilder.toString();
                        continue;
                    }
                    multipleMunge = true;
                    continue;
                }
                mungePath = folderPath;
            }
        }
        catch (IOException e) {
            try {
                throw new Task.ExecutionException("Failed to scan the addon: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                LauncherUtils.close(jarFile);
                LauncherUtils.close(in);
                throw throwable;
            }
        }
        LauncherUtils.close(jarFile);
        LauncherUtils.close(in);
        if (!foundClasses) {
            throw new Task.ExecutionException("The selected addon didn't have any Java .class files.");
        }
        boolean bl = needToMunge = !hasMcmodInfo && !hasRoot && mungePath != null && !multipleMunge;
        if (multipleMunge && !hasMcmodInfo) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(AddonInstallerTask.this.getComponent(), "There appears to be multiple folders with .class files. You may have to install this mod manually.", "Installation warning", 2);
                    }
                });
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (detectedModLoaderName != null && !multipleModLoaderMods) {
            id = detectedModLoaderName;
            name = detectedModLoaderName;
        }
        if (this.addonsProfile.hasInstalled(id)) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AddonInstallerTask.this.removeOther = JOptionPane.showConfirmDialog(AddonInstallerTask.this.getComponent(), "This addon appears to already be installed. Do you want to keep the other versions installed?", "Already installed", 0) != 0;
                    }
                });
            }
            catch (InterruptedException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        if (this.removeOther) {
            for (Addon addon : this.addonsProfile.getAddonsOfId(id)) {
                this.addonsProfile.remove(addon);
            }
            try {
                this.addonsProfile.write();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        File target = new File(this.addonsProfile.getDirectory(), this.file.getName());
        FileOutputStream out = null;
        JarInputStream jarIn = null;
        JarOutputStream jarOut = null;
        int nameIndex = 0;
        while (target.exists()) {
            if (this.addonsProfile.isUsing(target)) {
                target = new File(target.getParentFile(), nameIndex + "_" + target.getName());
                continue;
            }
            target.delete();
            break;
        }
        this.fireStatusChange("Installing files...");
        in = new FileInputStream(this.file);
        jarIn = new JarInputStream(new BufferedInputStream(in));
        out = new FileOutputStream(target);
        jarOut = new JarOutputStream(new BufferedOutputStream(out));
        byte[] buffer = new byte[8192];
        int i = 0;
        while ((entry = jarIn.getNextJarEntry()) != null) {
            LauncherUtils.checkInterrupted();
            if (entry.isDirectory()) continue;
            this.fireStatusChange("Installing " + entry.getName() + "...");
            this.fireValueChange((double)i / (double)entriesCount);
            String path = entry.getName().replace("\\", "/");
            if (path.matches("^.*\\.[DSA|SF]$") || path.startsWith("/")) continue;
            if (needToMunge && path.startsWith(mungePath)) {
                logger.finest("Munging the path " + path);
                if (path.length() > mungePath.length()) {
                    path = path.substring(mungePath.length());
                }
            }
            JarEntry outEntry = new JarEntry(path);
            jarOut.putNextEntry(outEntry);
            int len = 0;
            while ((len = jarIn.read(buffer, 0, buffer.length)) != -1) {
                jarOut.write(buffer, 0, len);
            }
            jarOut.closeEntry();
            ++i;
        }
        LauncherUtils.close(jarOut);
        LauncherUtils.close(jarIn);
        LauncherUtils.close(in);
        LauncherUtils.close(out);
        Addon addon = new Addon(id, name, null, target, null);
        this.addonsProfile.add(addon);
        try {
            this.addonsProfile.write();
            return;
        }
        catch (IOException e) {
            throw new Task.ExecutionException("Failed to write the addon list to disk: " + e.getMessage(), e);
        }
        catch (IOException e) {
            try {
                throw new Task.ExecutionException("Failed to install the addon: " + e.getMessage(), e);
                catch (InterruptedException e2) {
                    LauncherUtils.close(out);
                    target.delete();
                    throw new InterruptedException();
                }
            }
            catch (Throwable throwable) {
                LauncherUtils.close(jarOut);
                LauncherUtils.close(jarIn);
                LauncherUtils.close(in);
                LauncherUtils.close(out);
                throw throwable;
            }
        }
    }
}

