/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.AddonInstallerTask;
import com.sk89q.mclauncher.AddonUninstallerTask;
import com.sk89q.mclauncher.AddonsProfileLoaderTask;
import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.LauncherFrame;
import com.sk89q.mclauncher.addons.Addon;
import com.sk89q.mclauncher.addons.AddonsProfile;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.config.MinecraftJar;
import com.sk89q.mclauncher.config.SettingsList;
import com.sk89q.mclauncher.util.ActionListeners;
import com.sk89q.mclauncher.util.SwingHelper;
import com.sk89q.mclauncher.util.Task;
import com.sk89q.mclauncher.util.TaskWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;

public class AddonManagerDialog
extends JDialog {
    private static final long serialVersionUID = 3904227517893227045L;
    private LauncherFrame launcherFrame;
    private Configuration configuration;
    private JTable table;
    private JComboBox jarCombo;
    private AddonsProfile addonsProfile;
    private TaskWorker worker = new TaskWorker();
    private String lastSelectedJar = null;

    public AddonManagerDialog(LauncherFrame owner, Configuration config, String jar) {
        super(owner, "Manage Addons for configuration '" + config.getName() + "'", true);
        final AddonManagerDialog self = this;
        this.configuration = config;
        this.launcherFrame = owner;
        this.setResizable(true);
        this.buildUI();
        this.pack();
        this.setSize(550, 350);
        this.setLocationRelativeTo(owner);
        for (int i = 0; i < this.jarCombo.getItemCount(); ++i) {
            Object o = this.jarCombo.getItemAt(i);
            if (!o.toString().equals(jar)) continue;
            this.jarCombo.setSelectedItem(o);
        }
        this.loadAddonsProfile();
        this.lastSelectedJar = jar;
        this.jarCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object selected = ((JComboBox)e.getSource()).getSelectedItem();
                if (selected == null) {
                    return;
                }
                String jar = ((MinecraftJar)selected).getName();
                if (AddonManagerDialog.this.lastSelectedJar == null || AddonManagerDialog.this.lastSelectedJar != jar) {
                    AddonManagerDialog.this.lastSelectedJar = jar;
                    AddonManagerDialog.this.loadAddonsProfile();
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                AddonManagerDialog.this.saveAddonsProfile();
                Launcher.getInstance().getOptions().save();
                self.dispose();
            }
        });
    }

    public String getActiveJar() {
        Object o = this.jarCombo.getSelectedItem();
        if (o == null) {
            return "minecraft.jar";
        }
        return ((MinecraftJar)o).getName();
    }

    private void loadAddonsProfile() {
        if (this.worker.isAlive()) {
            return;
        }
        this.addonsProfile = null;
        AddonsProfile addonsProfile = this.configuration.getAddonsProfile(this.getActiveJar());
        this.worker = Task.startWorker(this, new AddonsProfileLoaderTask(addonsProfile, this));
    }

    void setAddonsProfile(AddonsProfile addonsProfile) {
        this.saveAddonsProfile();
        this.addonsProfile = addonsProfile;
        this.table.setModel(addonsProfile);
        this.table.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    private void saveAddonsProfile() {
        if (this.addonsProfile == null) {
            return;
        }
        if (!this.addonsProfile.save()) {
            JOptionPane.showMessageDialog(this, "Changes to addons profile could not be saved.", "Save error", 0);
        }
    }

    private boolean checkAddonsProfileLoaded() {
        if (this.addonsProfile == null) {
            SwingHelper.showError(this, "Not loaded", "The addon list could not be loaded, and so you cannot do this.");
            return false;
        }
        return true;
    }

    private void openInstallDialog() {
        if (this.worker.isAlive()) {
            return;
        }
        if (!this.checkAddonsProfileLoaded()) {
            return;
        }
        SettingsList settings = Launcher.getInstance().getOptions().getSettings();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Select addon to install");
        String lastFolder = settings.get("dir.last-install");
        if (lastFolder != null) {
            chooser.setCurrentDirectory(new File(lastFolder));
        }
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isDirectory()) {
                    return true;
                }
                String name = pathname.getName();
                int lastIndex = name.lastIndexOf(46);
                if (lastIndex == -1) {
                    return false;
                }
                String ext = name.substring(lastIndex + 1, name.length());
                return ext.equalsIgnoreCase("zip") || ext.equalsIgnoreCase("jar");
            }

            @Override
            public String getDescription() {
                return "Addon files (.zip; .jar)";
            }
        });
        int returnVal = chooser.showOpenDialog(this);
        settings.set("dir.last-install", chooser.getCurrentDirectory().getAbsolutePath());
        if (returnVal == 0) {
            this.worker = Task.startWorker(this, new AddonInstallerTask(this.addonsProfile, chooser.getSelectedFile()));
        }
    }

    private void startUninstall(List<Addon> addons) {
        if (this.worker.isAlive()) {
            return;
        }
        if (!this.checkAddonsProfileLoaded()) {
            return;
        }
        this.worker = Task.startWorker(this, new AddonUninstallerTask(this.addonsProfile, addons));
    }

    private void popupToolsMenu(Component component) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Open Minecraft data folder...");
        menuItem.addActionListener(ActionListeners.browseDir(this, this.configuration.getMinecraftDir(), false));
        popup.add(menuItem);
        menuItem = new JMenuItem("Open texture packs folder...");
        menuItem.addActionListener(ActionListeners.browseDir(this, this.configuration.getTexturePacksDir(), true));
        popup.add(menuItem);
        popup.show(component, 0, component.getHeight());
    }

    private void buildUI() {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout(8, 8));
        container.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.table = new JTable();
        this.table.setShowGrid(false);
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(2);
        JScrollPane tableScroll = new JScrollPane(this.table);
        container.add((Component)tableScroll, "Center");
        container.add((Component)this.buildButtons(), "South");
        container.add((Component)this.buildActiveJarSelector(), "North");
        container.add((Component)this.buildManageButtons(), "West");
        this.add((Component)container, "Center");
    }

    private JPanel buildActiveJarSelector() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JLabel("Active JAR:"));
        panel.add(Box.createHorizontalStrut(5));
        this.jarCombo = new JComboBox();
        this.jarCombo.setModel(this.configuration.getJars());
        panel.add(this.jarCombo);
        panel.add(Box.createHorizontalGlue());
        JButton toolsBtn = new JButton("Tools...");
        panel.add(toolsBtn);
        toolsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddonManagerDialog.this.popupToolsMenu((Component)e.getSource());
            }
        });
        return panel;
    }

    private JPanel buildManageButtons() {
        final AddonManagerDialog self = this;
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 1, 2, 1);
        GridBagConstraints vertFill = new GridBagConstraints();
        vertFill.anchor = 11;
        vertFill.fill = 3;
        vertFill.weighty = 1.0;
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        JButton installBtn = new JButton("Install...");
        panel.add((Component)installBtn, c);
        installBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddonManagerDialog.this.openInstallDialog();
            }
        });
        JButton moveUpBtn = new JButton("Move Up");
        moveUpBtn.setToolTipText("Higher entries are loaded first, so addons that are depended on by others should be near the top.");
        panel.add((Component)moveUpBtn, c);
        moveUpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AddonManagerDialog.this.checkAddonsProfileLoaded()) {
                    return;
                }
                int min = AddonManagerDialog.this.table.getSelectionModel().getMinSelectionIndex();
                int max = AddonManagerDialog.this.table.getSelectionModel().getMaxSelectionIndex();
                if (min != -1 && max != -1 && AddonManagerDialog.this.addonsProfile.moveUp(min, max)) {
                    AddonManagerDialog.this.table.getSelectionModel().setSelectionInterval(min - 1, max - 1);
                }
            }
        });
        JButton moveDownBtn = new JButton("Move Down");
        moveDownBtn.setToolTipText(moveUpBtn.getToolTipText());
        panel.add((Component)moveDownBtn, c);
        moveDownBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AddonManagerDialog.this.checkAddonsProfileLoaded()) {
                    return;
                }
                int min = AddonManagerDialog.this.table.getSelectionModel().getMinSelectionIndex();
                int max = AddonManagerDialog.this.table.getSelectionModel().getMaxSelectionIndex();
                if (min != -1 && max != -1 && AddonManagerDialog.this.addonsProfile.moveDown(min, max)) {
                    AddonManagerDialog.this.table.getSelectionModel().setSelectionInterval(min + 1, max + 1);
                }
            }
        });
        JButton deleteBtn = new JButton("Uninstall...");
        panel.add((Component)deleteBtn, c);
        deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AddonManagerDialog.this.checkAddonsProfileLoaded()) {
                    return;
                }
                int min = AddonManagerDialog.this.table.getSelectionModel().getMinSelectionIndex();
                int max = AddonManagerDialog.this.table.getSelectionModel().getMaxSelectionIndex();
                if (min == -1 || max == -1) {
                    JOptionPane.showMessageDialog(self, "You have not selected any addons.", "Selection error", 0);
                    return;
                }
                if (JOptionPane.showConfirmDialog(self, "Are you sure you want to uninstall the selected addons?", "Uninstall", 0) != 0) {
                    return;
                }
                ArrayList<Addon> addons = new ArrayList<Addon>();
                for (int i = min; i <= max; ++i) {
                    addons.add(AddonManagerDialog.this.addonsProfile.getAddonAt(i));
                }
                AddonManagerDialog.this.startUninstall(addons);
            }
        });
        panel.add(Box.createVerticalGlue(), vertFill);
        return panel;
    }

    private JPanel buildButtons() {
        final AddonManagerDialog self = this;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalGlue());
        JButton launchBtn = new JButton("Launch...");
        panel.add(launchBtn);
        launchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddonManagerDialog.this.saveAddonsProfile();
                Launcher.getInstance().getOptions().save();
                self.dispose();
                AddonManagerDialog.this.launcherFrame.launch();
            }
        });
        panel.add(Box.createHorizontalStrut(3));
        JButton testBtn = new JButton("Test...");
        panel.add(testBtn);
        testBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddonManagerDialog.this.saveAddonsProfile();
                Launcher.getInstance().getOptions().save();
                self.dispose();
                AddonManagerDialog.this.launcherFrame.getLaunchSettings().setTestMode();
                AddonManagerDialog.this.launcherFrame.launch();
            }
        });
        panel.add(Box.createHorizontalStrut(3));
        JButton okBtn = new JButton("Close");
        Dimension pref = okBtn.getPreferredSize();
        okBtn.setPreferredSize(new Dimension(Math.max(pref.width, 80), pref.height));
        panel.add(okBtn);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddonManagerDialog.this.saveAddonsProfile();
                Launcher.getInstance().getOptions().save();
                self.dispose();
            }
        });
        SwingHelper.equalWidth(launchBtn, testBtn, okBtn);
        return panel;
    }
}

