/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.addons.Addon;
import com.sk89q.mclauncher.addons.AddonsProfile;
import com.sk89q.mclauncher.util.LauncherUtils;
import com.sk89q.mclauncher.util.Task;
import java.io.IOException;
import java.util.List;

public class AddonUninstallerTask
extends Task {
    private AddonsProfile addonsProfile;
    private List<Addon> addons;

    public AddonUninstallerTask(AddonsProfile addonsProfile, List<Addon> addons) {
        this.addonsProfile = addonsProfile;
        this.addons = addons;
    }

    @Override
    protected void execute() throws Task.ExecutionException, InterruptedException {
        this.fireTitleChange("Uninstalling addons...");
        int i = 0;
        for (Addon addon : this.addons) {
            this.fireStatusChange("Uninstalling " + addon.getName() + "...");
            this.fireValueChange((double)i / (double)this.addons.size());
            LauncherUtils.checkInterrupted();
            this.addonsProfile.remove(addon);
            ++i;
        }
        try {
            this.addonsProfile.write();
        }
        catch (IOException e) {
            throw new Task.ExecutionException("Failed to write the addon list to disk: " + e.getMessage(), e);
        }
    }
}

