/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.AddonManagerDialog;
import com.sk89q.mclauncher.ConfigurationCellRenderer;
import com.sk89q.mclauncher.ConfigurationDialog;
import com.sk89q.mclauncher.InstallFromURLDialog;
import com.sk89q.mclauncher.LaunchOptions;
import com.sk89q.mclauncher.LauncherFrame;
import com.sk89q.mclauncher.LauncherView;
import com.sk89q.mclauncher.OptionsDialog;
import com.sk89q.mclauncher.WebpagePanel;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.config.Constants;
import com.sk89q.mclauncher.config.ServerEntry;
import com.sk89q.mclauncher.config.ServerList;
import com.sk89q.mclauncher.util.ActionListeners;
import com.sk89q.mclauncher.util.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ClassicView
extends LauncherView
implements ListSelectionListener,
ListDataListener {
    private static final long serialVersionUID = -2985136389385217242L;
    private static final int PAD = 12;
    private JList configurationList;
    private JButton playBtn;
    private WebpagePanel newsPanel;

    public ClassicView(LauncherFrame frame, final LaunchOptions launchOptions) {
        super(frame, launchOptions);
        this.addComponents();
        this.configurationList.getModel().addListDataListener(this);
        ListModel model = this.configurationList.getModel();
        Configuration startupConfiguration = this.options.getConfigurations().getStartupConfiguration();
        if (this.configurationList.getSelectedValue() != startupConfiguration) {
            for (int i = 0; i < model.getSize(); ++i) {
                if (model.getElementAt(i) != startupConfiguration) continue;
                this.configurationList.setSelectedIndex(i);
                break;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (launchOptions.hasLoginSet()) {
                    ClassicView.this.playBtn.requestFocusInWindow();
                } else {
                    launchOptions.focusEmptyField();
                }
            }
        });
    }

    private void addComponents() {
        this.setLayout(new BorderLayout(0, 0));
        boolean hideNews = this.options.getSettings().getBool("launcher.hidenews", false);
        if (!hideNews) {
            boolean lazyLoad = this.options.getSettings().getBool("launcher.newsless", false);
            this.newsPanel = new WebpagePanel(lazyLoad);
            this.newsPanel.setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 12));
            this.add((Component)this.newsPanel, "Center");
        }
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        if (!hideNews) {
            this.add((Component)leftPanel, "Before");
        } else {
            this.add((Component)leftPanel, "Center");
        }
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(1, 3, 3, 0));
        this.playBtn = new JButton("Play");
        JButton optionsBtn = new JButton("Options...");
        JButton addonsBtn = new JButton("Addons...");
        buttonsPanel.add(this.playBtn);
        buttonsPanel.add(addonsBtn);
        buttonsPanel.add(optionsBtn);
        JPanel root = new JPanel();
        root.setBorder(BorderFactory.createEmptyBorder(0, 12, 12, 12));
        root.setLayout(new BoxLayout(root, 1));
        root.add(this.launchOptions);
        root.add(buttonsPanel);
        leftPanel.add((Component)root, "South");
        JPanel configurationsPanel = new JPanel();
        configurationsPanel.setLayout(new BorderLayout(0, 0));
        configurationsPanel.setBorder(BorderFactory.createEmptyBorder(6, 12, 12, 12));
        this.configurationList = new JList(this.options.getConfigurations());
        this.configurationList.setCellRenderer(new ConfigurationCellRenderer());
        this.configurationList.setSelectionMode(0);
        this.configurationList.addListSelectionListener(this);
        this.configurationList.addListSelectionListener(this.launchOptions);
        JScrollPane configScroll = new JScrollPane(this.configurationList);
        configurationsPanel.add((Component)configScroll, "Center");
        leftPanel.add((Component)configurationsPanel, "Center");
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
        topPanel.setLayout(new BorderLayout());
        JButton installBtn = new JButton("Install from URL...");
        topPanel.add((Component)installBtn, "Center");
        leftPanel.add((Component)topPanel, "North");
        this.configurationList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ClassicView.this.configurationList.setSelectedIndex(ClassicView.this.configurationList.locationToIndex(e.getPoint()));
                    ClassicView.this.popupConfigurationMenu(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        installBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassicView.this.openInstallFromURL();
            }
        });
        this.playBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassicView.this.frame.launch();
            }
        });
        this.playBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ClassicView.this.popupServerHotListMenu(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        optionsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassicView.this.openOptions();
            }
        });
        addonsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassicView.this.openAddons();
            }
        });
        if (hideNews) {
            this.setSize(300, 500);
        }
    }

    @Override
    public Configuration getSelected() {
        return (Configuration)this.configurationList.getSelectedValue();
    }

    private OptionsDialog openOptions() {
        return this.openOptions(0);
    }

    private OptionsDialog openOptions(int index) {
        OptionsDialog dialog = new OptionsDialog(this.frame, this.getSelected(), this.options, index);
        dialog.setVisible(true);
        return dialog;
    }

    private AddonManagerDialog openAddons() {
        AddonManagerDialog dialog = new AddonManagerDialog(this.frame, this.getSelected(), this.launchOptions.getActiveJar().getName());
        dialog.setVisible(true);
        return dialog;
    }

    private InstallFromURLDialog openInstallFromURL() {
        InstallFromURLDialog dialog = new InstallFromURLDialog(this.frame, this.options);
        dialog.setVisible(true);
        return dialog;
    }

    private void popupConfigurationMenu(Component component, int x, int y) {
        final Configuration configuration = this.getSelected();
        if (configuration != null) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Edit '" + configuration.getName() + "'...");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new ConfigurationDialog((Window)ClassicView.this.frame, configuration).setVisible(true);
                }
            });
            popup.add(menuItem);
            menuItem = new JMenuItem("Delete '" + configuration.getName() + "'...");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!SwingHelper.confirm(ClassicView.this.frame, "Remove", "Are you sure you want to remove the selected configuration? No files will be deleted.")) {
                        return;
                    }
                    if (configuration.isBuiltIn()) {
                        SwingHelper.showError(ClassicView.this.frame, "Built-in configuration", "The configuration '" + configuration.getName() + "' is built-in and cannot be removed.");
                        return;
                    }
                    ClassicView.this.options.getConfigurations().remove(configuration);
                    ClassicView.this.options.save();
                }
            });
            popup.add(menuItem);
            menuItem = new JMenuItem("Open Minecraft data folder...");
            menuItem.addActionListener(ActionListeners.browseDir(this, configuration.getMinecraftDir(), false));
            popup.add(menuItem);
            menuItem = new JMenuItem("Open texture packs folder...");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File f = new File(configuration.getMinecraftDir(), "texturepacks");
                    f.mkdirs();
                    SwingHelper.browseDir(f, ClassicView.this.frame);
                }
            });
            popup.add(menuItem);
            popup.show(component, x, y);
        }
    }

    private void popupServerHotListMenu(Component component, int x, int y) {
        JMenuItem menuItem;
        ServerList servers = this.options.getServers();
        JPopupMenu popup = new JPopupMenu();
        for (final ServerEntry server : servers.getServers()) {
            menuItem = new JMenuItem("Connect to " + server.getName());
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClassicView.this.launchOptions.setAutoConnect(server.getAddress());
                    ClassicView.this.frame.launch();
                }
            });
            popup.add(menuItem);
        }
        if (servers.size() == 0) {
            menuItem = new JMenuItem("No servers in the hot list.");
            menuItem.setEnabled(false);
            popup.add(menuItem);
        }
        popup.show(component, x, y);
    }

    private void updateNews() {
        Configuration configuration = (Configuration)this.configurationList.getSelectedValue();
        if (this.newsPanel != null) {
            URL url = configuration.getNewsUrl();
            if (url == null) {
                url = Constants.NEWS_URL;
            }
            this.newsPanel.browse(url, true);
        }
    }

    @Override
    public void selectAfterSort() {
        this.configurationList.setSelectedIndex(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Configuration configuration = (Configuration)((JList)e.getSource()).getSelectedValue();
        for (ServerEntry entry : configuration.detectUserServers()) {
            entry.setTemporary(true);
            this.options.getServers().add(entry);
        }
        this.updateNews();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateNews();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updateNews();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateNews();
    }

    @Override
    public void cleanUp() {
        this.configurationList.getModel().removeListDataListener(this);
    }
}

