/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.config.Configuration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ConfigurationCellRenderer
implements ListCellRenderer {
    private static final int PAD = 5;
    private static BufferedImage defaultIcon;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Configuration configuration = (Configuration)value;
        JIconPanel panel = new JIconPanel(configuration.getIcon());
        panel.setLayout(new GridLayout(2, 1, 0, 1));
        panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 42, 5, 5));
        JLabel titleLabel = new JLabel();
        titleLabel.setText(configuration.getName());
        titleLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        Font font = titleLabel.getFont();
        font = font.deriveFont((float)((double)font.getSize() * 1.3)).deriveFont(1);
        titleLabel.setFont(font);
        panel.add(titleLabel);
        String infoText = configuration.isUsingDefaultPath() ? "Normal installation" : (configuration.getUpdateUrl() != null ? "via " + configuration.getUpdateUrl().getHost() : "Custom installation");
        JLabel infoLabel = new JLabel();
        infoLabel.setText(infoText);
        Color color = isSelected ? list.getSelectionForeground() : list.getForeground();
        infoLabel.setForeground(color);
        panel.add(infoLabel);
        return panel;
    }

    static {
        try {
            InputStream in = Launcher.class.getResourceAsStream("/resources/config_icon.png");
            if (in != null) {
                defaultIcon = ImageIO.read(in);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class JIconPanel
    extends JPanel {
        private static final long serialVersionUID = 6455230127195332368L;
        private BufferedImage icon;

        public JIconPanel(BufferedImage icon) {
            this.icon = icon;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension dim = this.getPreferredSize();
            if (this.icon != null) {
                g.drawImage(this.icon, 5, (int)((dim.getHeight() - 32.0) / 2.0), null);
            } else if (defaultIcon != null) {
                g.drawImage(defaultIcon, 5, (int)((dim.getHeight() - 32.0) / 2.0), null);
            }
        }
    }
}

