/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.EnvironmentOptionsPanel;
import com.sk89q.mclauncher.Launcher;
import com.sk89q.mclauncher.OptionsPanel;
import com.sk89q.mclauncher.config.Configuration;
import com.sk89q.mclauncher.config.ConfigurationList;
import com.sk89q.mclauncher.config.LauncherOptions;
import com.sk89q.mclauncher.config.SettingsList;
import com.sk89q.mclauncher.util.ActionListeners;
import com.sk89q.mclauncher.util.DirectoryField;
import com.sk89q.mclauncher.util.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConfigurationDialog
extends JDialog {
    private static final long serialVersionUID = -7347791965966294361L;
    private final Window dialog;
    private final LauncherOptions options;
    private final ConfigurationList configsManager;
    private final SettingsList settings;
    private Configuration configuration;
    private JTextField nameText;
    private DirectoryField pathField;
    private JCheckBox customPathCheck;
    private JTextField urlText;
    private JCheckBox customUpdateCheck;
    private List<OptionsPanel> optionsPanels = new ArrayList<OptionsPanel>();

    public ConfigurationDialog(Window owner, Configuration configuration) {
        super(owner, "Edit Configuration", Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog = owner;
        this.options = Launcher.getInstance().getOptions();
        this.configsManager = this.options.getConfigurations();
        this.configuration = configuration;
        this.settings = configuration.getSettings();
        this.setup();
    }

    public ConfigurationDialog(Window owner) {
        super(owner, "New Configuration", Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog = owner;
        this.options = Launcher.getInstance().getOptions();
        this.configsManager = this.options.getConfigurations();
        this.configuration = null;
        this.settings = new SettingsList();
        this.setup();
    }

    private void setup() {
        this.setResizable(false);
        this.buildUI();
        this.pack();
        this.setSize(400, 500);
        this.setLocationRelativeTo(this.dialog);
        for (OptionsPanel panel : this.optionsPanels) {
            panel.copySettingsToFields();
        }
        if (this.configuration != null) {
            this.nameText.setText(this.configuration.getName());
            if (this.configuration.isBuiltIn()) {
                this.customPathCheck.setSelected(true);
                this.pathField.setPath(this.configuration.getBaseDir().getPath());
            } else {
                boolean usingDefault = this.configuration.isUsingDefaultPath();
                this.customPathCheck.setSelected(!usingDefault);
                if (!usingDefault) {
                    this.pathField.setPath(this.configuration.getDirForOptions());
                }
            }
            URL updateUrl = this.configuration.getUpdateUrl();
            this.customUpdateCheck.setSelected(updateUrl != null);
            this.urlText.setEnabled(updateUrl != null);
            this.urlText.setText(updateUrl != null ? updateUrl.toString() : "");
            if (this.configuration.isBuiltIn()) {
                this.nameText.setEnabled(false);
                this.customPathCheck.setEnabled(false);
                this.pathField.setEnabled(false);
                this.customUpdateCheck.setEnabled(false);
                this.urlText.setEnabled(false);
            }
        }
    }

    private <T extends OptionsPanel> T wrap(T panel) {
        this.optionsPanels.add(panel);
        return panel;
    }

    private void buildUI() {
        final ConfigurationDialog self = this;
        JPanel container = new JPanel();
        container.setBorder(BorderFactory.createEmptyBorder(8, 8, 5, 8));
        container.setLayout(new BorderLayout(3, 3));
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Configuration", this.buildConfigurationPanel());
        tabs.addTab("Environment", this.wrap(new EnvironmentOptionsPanel(this.settings, true)));
        container.add((Component)tabs, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2, 5, 5));
        JButton okBtn = new JButton("OK");
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.setPreferredSize(new Dimension(70, (int)cancelBtn.getPreferredSize().getHeight()));
        okBtn.setPreferredSize(cancelBtn.getPreferredSize());
        buttonsPanel.add(okBtn);
        buttonsPanel.add(cancelBtn);
        container.add((Component)buttonsPanel, "South");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigurationDialog.this.complete()) {
                    self.dispose();
                }
            }
        });
        cancelBtn.addActionListener(ActionListeners.dipose(this));
        this.add((Component)container, "Center");
    }

    private JPanel buildConfigurationPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        fieldConstraints.fill = 2;
        fieldConstraints.weightx = 1.0;
        fieldConstraints.gridwidth = 0;
        fieldConstraints.insets = new Insets(2, 1, 2, 1);
        GridBagConstraints labelConstraints = (GridBagConstraints)fieldConstraints.clone();
        labelConstraints.weightx = 0.0;
        labelConstraints.gridwidth = 1;
        labelConstraints.insets = new Insets(1, 1, 1, 10);
        GridBagConstraints fullFieldConstraints = (GridBagConstraints)fieldConstraints.clone();
        fullFieldConstraints.insets = new Insets(5, 2, 1, 2);
        if (this.configuration != null && this.configuration.isBuiltIn()) {
            panel.add((Component)new JLabel("This is a built-in configuration and editing is restricted."), fullFieldConstraints);
            panel.add(Box.createVerticalStrut(10), fullFieldConstraints);
        }
        JLabel nameLabel = new JLabel("Name:");
        panel.add((Component)nameLabel, labelConstraints);
        this.nameText = new JTextField(30);
        nameLabel.setLabelFor(this.nameText);
        panel.add((Component)this.nameText, fieldConstraints);
        JLabel pathLabel = new JLabel("Path:");
        panel.add((Component)pathLabel, labelConstraints);
        this.customPathCheck = new JCheckBox("Use a custom path");
        this.customPathCheck.setBorder(null);
        panel.add((Component)this.customPathCheck, fieldConstraints);
        panel.add(Box.createGlue(), labelConstraints);
        this.pathField = new DirectoryField();
        this.pathField.getTextField().setMaximumSize(this.pathField.getTextField().getPreferredSize());
        nameLabel.setLabelFor(this.pathField.getTextField());
        panel.add((Component)this.pathField, fieldConstraints);
        panel.add(Box.createVerticalStrut(10), fullFieldConstraints);
        JLabel urlLabel = new JLabel("Update URL:");
        panel.add((Component)urlLabel, labelConstraints);
        this.customUpdateCheck = new JCheckBox("Use a custom update URL");
        this.customUpdateCheck.setBorder(null);
        panel.add((Component)this.customUpdateCheck, fieldConstraints);
        panel.add(Box.createGlue(), labelConstraints);
        this.urlText = new JTextField("http://");
        urlLabel.setLabelFor(this.urlText);
        panel.add((Component)this.urlText, fieldConstraints);
        this.pathField.setEnabled(false);
        this.customPathCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConfigurationDialog.this.pathField.setEnabled(((JCheckBox)e.getSource()).isSelected());
            }
        });
        this.urlText.setEnabled(false);
        this.customUpdateCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConfigurationDialog.this.urlText.setEnabled(((JCheckBox)e.getSource()).isSelected());
            }
        });
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        container.add(panel);
        container.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 10000), new Dimension(0, 10000)));
        SwingHelper.removeOpaqueness(container);
        return container;
    }

    private boolean complete() {
        boolean builtIn = this.configuration != null && this.configuration.isBuiltIn();
        String name = this.nameText.getText().trim();
        String pathStr = this.customPathCheck.isSelected() ? this.pathField.getPath().trim() : null;
        String updateURLStr = this.customUpdateCheck.isSelected() ? this.urlText.getText() : null;
        URL updateUrl = null;
        if (!builtIn) {
            if (name.length() == 0) {
                SwingHelper.showError(this, "No name", "A name must be entered.");
                return false;
            }
            if (pathStr != null && pathStr.length() == 0) {
                SwingHelper.showError(this, "No path", "A path must be entered.");
                return false;
            }
            if (updateURLStr != null && updateURLStr.length() == 0) {
                SwingHelper.showError(this, "No URL", "An update URL must be entered.");
                return false;
            }
            if (updateURLStr != null) {
                try {
                    updateUrl = new URL(updateURLStr);
                }
                catch (MalformedURLException e) {
                    SwingHelper.showError(this, "Invalid URL", "The update URL that you entered is invalid.");
                    return false;
                }
            }
            if (pathStr != null) {
                File f = Launcher.replacePathTokens(pathStr);
                f.mkdirs();
                if (!f.isDirectory()) {
                    SwingHelper.showError(this, "Invalid path", "The path that you entered does not exist or is not a directory.");
                    return false;
                }
            }
        }
        for (OptionsPanel panel : this.optionsPanels) {
            panel.copyFieldsToSettings();
        }
        if (this.configuration == null) {
            String id = UUID.randomUUID().toString();
            Configuration config = Configuration.createCustom(id, name, pathStr, updateUrl);
            config.setSettings(this.settings);
            this.configsManager.register(config);
            this.configuration = config;
        } else if (!builtIn) {
            this.configuration.setName(name);
            this.configuration.setCustomBasePath(pathStr);
            this.configuration.setUpdateUrl(updateUrl);
        }
        this.options.save();
        return true;
    }
}

