/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.mclauncher;

import com.sk89q.mclauncher.InstallFromURLTask;
import com.sk89q.mclauncher.LauncherFrame;
import com.sk89q.mclauncher.config.LauncherOptions;
import com.sk89q.mclauncher.util.ActionListeners;
import com.sk89q.mclauncher.util.LinkButton;
import com.sk89q.mclauncher.util.SwingHelper;
import com.sk89q.mclauncher.util.Task;
import com.sk89q.mclauncher.util.TaskWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class InstallFromURLDialog
extends JDialog {
    private static final long serialVersionUID = 3904227517893227045L;
    private LauncherOptions options;
    private JTextField urlText;
    private TaskWorker worker = new TaskWorker();

    public InstallFromURLDialog(LauncherFrame owner, LauncherOptions options) {
        super(owner, "Install From URL", true);
        this.options = options;
        this.setResizable(false);
        this.buildUI();
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setDefaultCloseOperation(2);
    }

    private void startInstall(String url) {
        if (this.worker.isAlive()) {
            return;
        }
        this.worker = Task.startWorker(this, new InstallFromURLTask(this, this.options, url));
    }

    private void buildUI() {
        JPanel container = new JPanel();
        container.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        container.setLayout(new BorderLayout(3, 3));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints fieldConstraints = new GridBagConstraints();
        fieldConstraints.fill = 2;
        fieldConstraints.weightx = 1.0;
        fieldConstraints.gridwidth = 0;
        fieldConstraints.insets = new Insets(2, 1, 2, 1);
        GridBagConstraints labelConstraints = (GridBagConstraints)fieldConstraints.clone();
        labelConstraints.weightx = 0.0;
        labelConstraints.gridwidth = 1;
        labelConstraints.insets = new Insets(1, 1, 1, 10);
        GridBagConstraints fullFieldConstraints = (GridBagConstraints)fieldConstraints.clone();
        fullFieldConstraints.insets = new Insets(5, 2, 1, 2);
        JLabel urlLabel = new JLabel("URL to Install:");
        panel.add((Component)urlLabel, labelConstraints);
        this.urlText = new JTextField(this.getURLFromClipboard());
        this.urlText.selectAll();
        this.urlText.setPreferredSize(new Dimension(300, (int)this.urlText.getPreferredSize().getHeight()));
        panel.add((Component)this.urlText, fullFieldConstraints);
        container.add((Component)panel, "Center");
        JLabel infoLabel = new JLabel("<html>Copy and paste the URL that you have been given in order to install the mod pack.");
        container.add((Component)infoLabel, "North");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(16, 0, 0, 0));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        LinkButton createButton = new LinkButton("Build your own package...");
        JButton okBtn = new JButton("Install");
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.setPreferredSize(new Dimension(70, (int)cancelBtn.getPreferredSize().getHeight()));
        okBtn.setPreferredSize(cancelBtn.getPreferredSize());
        buttonsPanel.add(createButton);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(okBtn);
        buttonsPanel.add(Box.createHorizontalStrut(6));
        buttonsPanel.add(cancelBtn);
        container.add((Component)buttonsPanel, "South");
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallFromURLDialog.this.openBuilder();
            }
        });
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = InstallFromURLDialog.this.urlText.getText();
                if (!text.isEmpty()) {
                    InstallFromURLDialog.this.startInstall(text);
                }
            }
        });
        cancelBtn.addActionListener(ActionListeners.dipose(this));
        this.urlText.requestFocus();
        this.add((Component)container, "Center");
    }

    private void openBuilder() {
        try {
            Class<?> cls = Class.forName("com.sk89q.lpbuilder.UpdateBuilderGUI");
            if (cls == null) {
                throw new Exception();
            }
            final JFrame frame = (JFrame)cls.newInstance();
            frame.setVisible(true);
            this.dispose();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.requestFocus();
                }
            });
        }
        catch (Throwable t) {
            SwingHelper.showError(this, "Error", "Couldn't open builder GUI.");
        }
    }

    private String getURLFromClipboard() {
        try {
            String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
            if (data != null && data.toLowerCase().matches("^https?://.*$")) {
                return data;
            }
        }
        catch (HeadlessException e) {
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }
}

